/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper.mappers;

import cn.xbatis.core.mybatis.mapper.context.strategy.SaveBatchStrategy;
import cn.xbatis.core.mybatis.mapper.context.strategy.SaveStrategy;
import cn.xbatis.core.mybatis.mapper.mappers.BaseMapper;
import cn.xbatis.core.mybatis.mapper.mappers.utils.SaveMethodUtil;
import cn.xbatis.core.sql.executor.Insert;
import db.sql.api.Getter;
import java.util.Collection;
import java.util.function.Consumer;

public interface SaveMapper<T>
extends BaseMapper<T> {
    default public int save(T entity, Consumer<SaveStrategy<T>> consumer) {
        SaveStrategy strategy = new SaveStrategy();
        consumer.accept(strategy);
        return SaveMethodUtil.save(this.getBasicMapper(), this.getTableInfo(), entity, strategy);
    }

    default public int save(T entity) {
        return this.save(entity, false);
    }

    default public int save(T entity, boolean allFieldForce) {
        return this.save(entity, (SaveStrategy<T> saveStrategy) -> saveStrategy.allFieldSave(allFieldForce));
    }

    default public int save(T entity, Getter<T> ... forceFields) {
        return this.save(entity, (SaveStrategy<T> saveStrategy) -> saveStrategy.forceFields(forceFields));
    }

    default public int save(Collection<T> list, Consumer<SaveStrategy<T>> saveStrategy) {
        if (list == null || list.isEmpty()) {
            return 0;
        }
        SaveStrategy strategy = new SaveStrategy();
        saveStrategy.accept(strategy);
        return SaveMethodUtil.saveList(this.getBasicMapper(), this.getTableInfo(), list, strategy);
    }

    default public int save(Collection<T> list) {
        return this.save(list, false);
    }

    default public int save(Collection<T> list, boolean allFieldForce) {
        return this.save(list, (SaveStrategy<T> saveStrategy) -> saveStrategy.allFieldSave(allFieldForce));
    }

    default public int save(Collection<T> list, Getter<T> ... forceFields) {
        return this.save(list, (SaveStrategy<T> saveStrategy) -> saveStrategy.forceFields(forceFields));
    }

    default public int saveBatch(Collection<T> list, Consumer<SaveBatchStrategy<T>> saveBatchStrategy) {
        SaveBatchStrategy strategy = new SaveBatchStrategy();
        saveBatchStrategy.accept(strategy);
        return SaveMethodUtil.saveBatch(this.getBasicMapper(), new Insert(), this.getTableInfo(), list, strategy);
    }

    default public int saveBatch(Collection<T> list) {
        return SaveMethodUtil.saveBatch(this.getBasicMapper(), list);
    }

    default public int saveBatch(Collection<T> list, Getter<T> ... forceFields) {
        return this.saveBatch(list, (SaveBatchStrategy<T> saveStrategy) -> saveStrategy.forceFields(forceFields));
    }
}

