/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper.context;

import cn.xbatis.core.db.reflect.ModelFieldInfo;
import cn.xbatis.core.db.reflect.ModelInfo;
import cn.xbatis.core.db.reflect.TableIds;
import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.incrementer.IdentifierGenerator;
import cn.xbatis.core.incrementer.IdentifierGeneratorFactory;
import cn.xbatis.core.mybatis.mapper.context.IdUtil;
import cn.xbatis.core.mybatis.mapper.context.MybatisParameter;
import cn.xbatis.core.mybatis.mapper.context.strategy.SaveBatchStrategy;
import cn.xbatis.core.sql.MybatisCmdFactory;
import cn.xbatis.core.sql.executor.BaseInsert;
import cn.xbatis.core.sql.executor.Insert;
import cn.xbatis.core.tenant.TenantUtil;
import cn.xbatis.core.util.DefaultValueUtil;
import cn.xbatis.core.util.ModelInfoUtil;
import cn.xbatis.core.util.TableInfoUtil;
import cn.xbatis.core.util.TypeConvertUtil;
import cn.xbatis.db.IdAutoType;
import cn.xbatis.db.Model;
import cn.xbatis.db.annotations.TableField;
import cn.xbatis.db.annotations.TableId;
import db.sql.api.DbType;
import db.sql.api.cmd.basic.ITable;
import db.sql.api.impl.cmd.Methods;
import db.sql.api.impl.cmd.basic.NULL;
import db.sql.api.impl.cmd.basic.Table;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ModelBatchInsertCreateUtil {
    private static Set<String> getAllSaveField(ModelInfo modelInfo, DbType dbType, Model model) {
        HashSet<String> saveFieldSet = new HashSet<String>();
        for (ModelFieldInfo modelFieldInfo : modelInfo.getModelFieldInfos()) {
            if (modelFieldInfo.getTableFieldInfo().isTableId()) {
                TableId tableId = TableInfoUtil.getTableIdAnnotation(modelFieldInfo.getTableFieldInfo().getField(), dbType);
                Objects.requireNonNull(tableId.value());
                if (tableId.value() == IdAutoType.AUTO) {
                    Object id;
                    try {
                        id = modelFieldInfo.getReadFieldInvoker().invoke((Object)model, null);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    if (Objects.isNull(id)) continue;
                }
            }
            saveFieldSet.add(modelFieldInfo.getField().getName());
        }
        return saveFieldSet;
    }

    public static <T extends Model> BaseInsert<?> create(BaseInsert<?> insert, ModelInfo modelInfo, T[] insertData, SaveBatchStrategy<T> saveBatchStrategy, DbType dbType, boolean useBatchExecutor) {
        insert = insert == null ? new Insert() : insert;
        TableInfo tableInfo = modelInfo.getTableInfo();
        ((MybatisCmdFactory)insert.$()).cacheTableInfo(tableInfo);
        Table table = (Table)((MybatisCmdFactory)insert.$()).table(tableInfo.getType());
        insert.insert((ITable)table);
        Set<String> saveFieldSet = saveBatchStrategy.getForceFields() == null || saveBatchStrategy.getForceFields().isEmpty() ? ModelBatchInsertCreateUtil.getAllSaveField(modelInfo, dbType, insertData[0]) : saveBatchStrategy.getForceFields();
        List saveFieldInfoSet = saveFieldSet.stream().map(modelInfo::getFieldInfo).collect(Collectors.toList());
        if (!modelInfo.getIdFieldInfos().isEmpty()) {
            modelInfo.getIdFieldInfos().forEach(idFieldInfo -> {
                TableId tableId = TableInfoUtil.getTableIdAnnotation(idFieldInfo.getTableFieldInfo().getField(), dbType);
                if (tableId.value() == IdAutoType.GENERATOR && !saveFieldInfoSet.contains(idFieldInfo)) {
                    saveFieldInfoSet.add(idFieldInfo);
                }
            });
        }
        if (Objects.nonNull(modelInfo.getTenantIdFieldInfo()) && !saveFieldInfoSet.contains(modelInfo.getTenantIdFieldInfo())) {
            saveFieldInfoSet.add(modelInfo.getTenantIdFieldInfo());
        }
        if (Objects.nonNull(modelInfo.getVersionFieldInfo()) && !saveFieldInfoSet.contains(modelInfo.getVersionFieldInfo())) {
            saveFieldInfoSet.add(modelInfo.getVersionFieldInfo());
        }
        if (Objects.nonNull(modelInfo.getLogicDeleteFieldInfo()) && !saveFieldInfoSet.contains(modelInfo.getLogicDeleteFieldInfo())) {
            saveFieldInfoSet.add(modelInfo.getLogicDeleteFieldInfo());
        }
        for (ModelFieldInfo modelFieldInfo : saveFieldInfoSet) {
            insert.fields(((MybatisCmdFactory)insert.$()).field(table, modelFieldInfo.getTableFieldInfo().getColumnName(), modelFieldInfo.getTableFieldInfo().isTableId()));
        }
        int fieldSize = saveFieldInfoSet.size();
        boolean containId = false;
        for (T t : insertData) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (int i = 0; i < fieldSize; ++i) {
                boolean hasValue;
                ModelFieldInfo modelFieldInfo = (ModelFieldInfo)saveFieldInfoSet.get(i);
                Object value = modelFieldInfo.getValue(t);
                boolean bl = hasValue = !modelFieldInfo.getTableFieldInfo().isTableId() && Objects.nonNull(value) || modelFieldInfo.getTableFieldInfo().isTableId() && IdUtil.isIdValueExists(value);
                if (!hasValue) {
                    if (modelFieldInfo.getTableFieldInfo().isTableId()) {
                        for (ModelFieldInfo idFieldInfo2 : modelInfo.getIdFieldInfos()) {
                            TableId tableId = TableInfoUtil.getTableIdAnnotation(idFieldInfo2.getTableFieldInfo().getField(), dbType);
                            if (tableId.value() == IdAutoType.GENERATOR) {
                                IdentifierGenerator identifierGenerator = IdentifierGeneratorFactory.getIdentifierGenerator(tableId.generatorName());
                                Object id = identifierGenerator.nextId(modelInfo.getTableInfo().getType());
                                if (!IdUtil.setId(t, modelFieldInfo, id)) continue;
                                value = id;
                                continue;
                            }
                            throw new RuntimeException(modelFieldInfo.getField().getName() + " has no value");
                        }
                    } else if (modelFieldInfo.getTableFieldInfo().isTenantId()) {
                        value = TenantUtil.setTenantId(t);
                    } else if (modelFieldInfo.getTableFieldInfo().isLogicDelete()) {
                        value = modelFieldInfo.getTableFieldInfo().getLogicDeleteInitValue();
                        if (value != null) {
                            ModelInfoUtil.setValue(modelFieldInfo, t, value);
                        } else if (!"".equals(modelFieldInfo.getTableFieldInfo().getTableFieldAnnotation().defaultValue())) {
                            value = DefaultValueUtil.getAndSetDefaultValue(t, modelFieldInfo);
                        }
                    } else if (!"".equals(modelFieldInfo.getTableFieldInfo().getTableFieldAnnotation().defaultValue())) {
                        value = DefaultValueUtil.getAndSetDefaultValue(t, modelFieldInfo);
                    } else if (modelFieldInfo.getTableFieldInfo().isVersion()) {
                        value = TypeConvertUtil.convert(1, modelFieldInfo.getField().getType());
                        ModelInfoUtil.setValue(modelFieldInfo, t, value);
                    }
                }
                if (modelFieldInfo.getTableFieldInfo().isTableId()) {
                    containId = true;
                }
                TableField tableField = modelFieldInfo.getTableFieldInfo().getTableFieldAnnotation();
                if (Objects.isNull(value)) {
                    values.add(NULL.NULL);
                    continue;
                }
                MybatisParameter mybatisParameter = new MybatisParameter(value, tableField.typeHandler(), tableField.jdbcType());
                values.add(Methods.cmd((Object)mybatisParameter));
            }
            insert.values(values);
        }
        if (dbType == DbType.SQL_SERVER && insert.getInsertValues().getValues().size() > 0) {
            TableId tableId = TableIds.get(modelInfo.getEntityType(), dbType);
            if (!useBatchExecutor && !containId && Objects.nonNull(tableId) && tableId.value() == IdAutoType.AUTO) {
                insert.getInsertFields().setOutput("OUTPUT INSERTED." + modelInfo.getTableInfo().getIdFieldInfo().getColumnName());
            }
        }
        if (saveBatchStrategy.getConflictAction() != null) {
            insert.conflictKeys(saveBatchStrategy.getConflictKeys());
            insert.conflictKeys(saveBatchStrategy.getConflictColumns());
            insert.onConflict(saveBatchStrategy.getConflictAction());
        }
        return insert;
    }
}

