/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper.context;

import cn.xbatis.core.db.reflect.TableFieldInfo;
import cn.xbatis.core.db.reflect.TableIds;
import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.incrementer.IdentifierGenerator;
import cn.xbatis.core.incrementer.IdentifierGeneratorFactory;
import cn.xbatis.core.mybatis.mapper.context.IdUtil;
import cn.xbatis.core.mybatis.mapper.context.MybatisParameter;
import cn.xbatis.core.mybatis.mapper.context.strategy.SaveBatchStrategy;
import cn.xbatis.core.sql.MybatisCmdFactory;
import cn.xbatis.core.sql.executor.BaseInsert;
import cn.xbatis.core.sql.executor.Insert;
import cn.xbatis.core.tenant.TenantUtil;
import cn.xbatis.core.util.DefaultValueUtil;
import cn.xbatis.core.util.TableInfoUtil;
import cn.xbatis.core.util.TypeConvertUtil;
import cn.xbatis.db.IdAutoType;
import cn.xbatis.db.annotations.TableField;
import cn.xbatis.db.annotations.TableId;
import db.sql.api.DbType;
import db.sql.api.cmd.basic.ITable;
import db.sql.api.impl.cmd.Methods;
import db.sql.api.impl.cmd.basic.NULL;
import db.sql.api.impl.cmd.basic.Table;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class EntityBatchInsertCreateUtil {
    private static Set<String> getAllSaveField(TableInfo tableInfo, DbType dbType, Object entity) {
        HashSet<String> saveFieldSet = new HashSet<String>();
        for (TableFieldInfo tableFieldInfo : tableInfo.getTableFieldInfos()) {
            if (!tableFieldInfo.getTableFieldAnnotation().insert()) continue;
            if (tableFieldInfo.isTableId()) {
                TableId tableId = TableInfoUtil.getTableIdAnnotation(tableFieldInfo.getField(), dbType);
                Objects.requireNonNull(tableId.value());
                if (tableId.value() == IdAutoType.AUTO) {
                    Object id;
                    try {
                        id = tableFieldInfo.getReadFieldInvoker().invoke(entity, null);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    if (Objects.isNull(id)) continue;
                }
            }
            saveFieldSet.add(tableFieldInfo.getField().getName());
        }
        return saveFieldSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> BaseInsert<?> create(BaseInsert<?> insert, TableInfo tableInfo, T[] insertData, SaveBatchStrategy<T> saveBatchStrategy, DbType dbType, boolean useBatchExecutor) {
        insert = insert == null ? new Insert() : insert;
        ((MybatisCmdFactory)insert.$()).cacheTableInfo(tableInfo);
        Table table = (Table)((MybatisCmdFactory)insert.$()).table(tableInfo.getType());
        insert.insert((ITable)table);
        Set<String> saveFieldSet = saveBatchStrategy.getForceFields() == null || saveBatchStrategy.getForceFields().isEmpty() ? EntityBatchInsertCreateUtil.getAllSaveField(tableInfo, dbType, insertData[0]) : saveBatchStrategy.getForceFields();
        List saveFieldInfoSet = saveFieldSet.stream().map(tableInfo::getFieldInfo).collect(Collectors.toList());
        if (!tableInfo.getIdFieldInfos().isEmpty()) {
            tableInfo.getIdFieldInfos().forEach(idFieldInfo -> {
                TableId tableId = TableInfoUtil.getTableIdAnnotation(idFieldInfo.getField(), dbType);
                if (!(tableId.value() != IdAutoType.GENERATOR && tableId.value() != IdAutoType.SQL || saveFieldInfoSet.contains(idFieldInfo))) {
                    saveFieldInfoSet.add(idFieldInfo);
                }
            });
        }
        if (Objects.nonNull(tableInfo.getTenantIdFieldInfo()) && !saveFieldInfoSet.contains(tableInfo.getTenantIdFieldInfo())) {
            saveFieldInfoSet.add(tableInfo.getTenantIdFieldInfo());
        }
        if (Objects.nonNull(tableInfo.getVersionFieldInfo()) && !saveFieldInfoSet.contains(tableInfo.getVersionFieldInfo())) {
            saveFieldInfoSet.add(tableInfo.getVersionFieldInfo());
        }
        if (Objects.nonNull(tableInfo.getLogicDeleteFieldInfo()) && !saveFieldInfoSet.contains(tableInfo.getLogicDeleteFieldInfo())) {
            saveFieldInfoSet.add(tableInfo.getLogicDeleteFieldInfo());
        }
        for (TableFieldInfo tableFieldInfo : saveFieldInfoSet) {
            insert.fields(((MybatisCmdFactory)insert.$()).field(table, tableFieldInfo.getColumnName(), tableFieldInfo.isTableId()));
        }
        int fieldSize = saveFieldInfoSet.size();
        boolean containId = false;
        for (T t : insertData) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (int i = 0; i < fieldSize; ++i) {
                boolean hasValue;
                TableFieldInfo tableFieldInfo = (TableFieldInfo)saveFieldInfoSet.get(i);
                Object value = tableFieldInfo.getValue(t);
                boolean bl = hasValue = !tableFieldInfo.isTableId() && Objects.nonNull(value) || tableFieldInfo.isTableId() && IdUtil.isIdValueExists(value);
                if (!hasValue) {
                    if (tableFieldInfo.isTableId()) {
                        TableId tableId = TableInfoUtil.getTableIdAnnotation(tableFieldInfo.getField(), dbType);
                        if (tableId.value() != IdAutoType.GENERATOR) throw new RuntimeException(tableFieldInfo.getField().getName() + " has no value");
                        IdentifierGenerator identifierGenerator = IdentifierGeneratorFactory.getIdentifierGenerator(tableId.generatorName());
                        Object id = identifierGenerator.nextId(tableInfo.getType());
                        if (IdUtil.setId(t, tableFieldInfo, id)) {
                            value = id;
                        }
                    } else if (tableFieldInfo.isTenantId()) {
                        value = TenantUtil.setTenantId(t);
                    } else if (tableFieldInfo.isLogicDelete()) {
                        value = tableFieldInfo.getLogicDeleteInitValue();
                        if (value != null) {
                            TableInfoUtil.setValue(tableFieldInfo, t, value);
                        } else if (!"".equals(tableFieldInfo.getTableFieldAnnotation().defaultValue())) {
                            value = DefaultValueUtil.getAndSetDefaultValue(t, tableFieldInfo);
                        }
                    } else if (!"".equals(tableFieldInfo.getTableFieldAnnotation().defaultValue())) {
                        value = DefaultValueUtil.getAndSetDefaultValue(t, tableFieldInfo);
                    } else if (tableFieldInfo.isVersion()) {
                        value = TypeConvertUtil.convert(1, tableFieldInfo.getField().getType());
                        TableInfoUtil.setValue(tableFieldInfo, t, value);
                    }
                }
                if (tableFieldInfo.isTableId()) {
                    containId = true;
                }
                TableField tableField = tableFieldInfo.getTableFieldAnnotation();
                if (Objects.isNull(value)) {
                    values.add(NULL.NULL);
                    continue;
                }
                MybatisParameter mybatisParameter = new MybatisParameter(value, tableField.typeHandler(), tableField.jdbcType());
                values.add(Methods.cmd((Object)mybatisParameter));
            }
            insert.values(values);
        }
        if (dbType == DbType.SQL_SERVER && insert.getInsertValues().getValues().size() > 0) {
            TableId tableId = TableIds.get(tableInfo.getType(), dbType);
            if (!useBatchExecutor && !containId && Objects.nonNull(tableId) && tableId.value() == IdAutoType.AUTO) {
                insert.getInsertFields().setOutput("OUTPUT INSERTED." + tableInfo.getIdFieldInfo().getColumnName());
            }
        }
        if (saveBatchStrategy.getConflictAction() == null) return insert;
        insert.conflictKeys(saveBatchStrategy.getConflictKeys());
        insert.conflictKeys(saveBatchStrategy.getConflictColumns());
        insert.onConflict(saveBatchStrategy.getConflictAction());
        return insert;
    }
}

