/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.executor.statement;

import cn.xbatis.core.mybatis.executor.statement.Fetchable;
import cn.xbatis.core.mybatis.executor.statement.Timeoutable;
import cn.xbatis.core.mybatis.mapper.context.BaseSQLCmdContext;
import db.sql.api.DbType;
import db.sql.api.impl.tookit.Objects;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementUtil;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class MybatisRoutingStatementHandler
extends RoutingStatementHandler {
    private final Object parameter;

    public MybatisRoutingStatementHandler(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        super(executor, ms, parameter, rowBounds, resultHandler, boundSql);
        this.parameter = parameter;
    }

    public Statement prepare(Connection connection, Integer transactionTimeout) throws SQLException {
        Statement statement = super.prepare(connection, transactionTimeout);
        if (this.parameter instanceof BaseSQLCmdContext) {
            Timeoutable timeoutable;
            BaseSQLCmdContext sqlCmdContext = (BaseSQLCmdContext)this.parameter;
            if (sqlCmdContext.getExecution() instanceof Timeoutable && Objects.nonNull((Object)(timeoutable = (Timeoutable)sqlCmdContext.getExecution()).getTimeout())) {
                statement.setQueryTimeout(timeoutable.getTimeout());
                StatementUtil.applyTransactionTimeout((Statement)statement, (Integer)timeoutable.getTimeout(), (Integer)transactionTimeout);
            }
            if (sqlCmdContext.getExecution() instanceof Fetchable) {
                Fetchable fetchable = (Fetchable)sqlCmdContext.getExecution();
                if (Objects.nonNull((Object)fetchable.getFetchSize())) {
                    statement.setFetchSize(fetchable.getFetchSize());
                }
                if (Objects.nonNull((Object)fetchable.getFetchDirection()) && sqlCmdContext.getDbType() != DbType.SQLITE) {
                    statement.setFetchDirection(fetchable.getFetchDirection());
                }
            }
        }
        return statement;
    }
}

