/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.executor;

import cn.xbatis.core.mybatis.configuration.MybatisConfiguration;
import cn.xbatis.core.mybatis.executor.PreparedParameterContext;
import cn.xbatis.core.mybatis.mapper.context.MybatisLikeQueryParameter;
import cn.xbatis.core.mybatis.mapper.context.MybatisParameter;
import cn.xbatis.core.mybatis.typeHandler.LikeQuerySupport;
import cn.xbatis.core.mybatis.typeHandler.MybatisTypeHandlerUtil;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.UnknownTypeHandler;

public class PreparedParameterHandler
implements ParameterHandler {
    private final PreparedParameterContext parameterContext;
    private final MybatisConfiguration configuration;

    public PreparedParameterHandler(MybatisConfiguration configuration, PreparedParameterContext parameterContext) {
        this.configuration = configuration;
        this.parameterContext = parameterContext;
    }

    public Object getParameterObject() {
        return this.parameterContext;
    }

    private int setParameters(PreparedStatement ps, int index, Object value, TypeHandler typeHandler, JdbcType jdbcType) throws SQLException {
        if (Objects.isNull(value)) {
            ps.setNull(++index, 0);
            return index;
        }
        if (jdbcType == JdbcType.UNDEFINED) {
            jdbcType = null;
        }
        if (value instanceof Supplier) {
            return this.setParameters(ps, index, ((Supplier)value).get(), (TypeHandler)typeHandler, jdbcType);
        }
        if (value instanceof MybatisLikeQueryParameter) {
            MybatisLikeQueryParameter parameter = (MybatisLikeQueryParameter)value;
            Object realValue = parameter.getValue();
            if (realValue == null) {
                return this.setParameters(ps, index, null, null, null);
            }
            if (typeHandler == null || parameter.getTypeHandler() != typeHandler.getClass()) {
                typeHandler = MybatisTypeHandlerUtil.getTypeHandler(this.configuration, realValue.getClass(), parameter.getTypeHandler());
            }
            if (typeHandler instanceof LikeQuerySupport) {
                LikeQuerySupport querySupport = (LikeQuerySupport)typeHandler;
                querySupport.setLikeParameter(parameter.getLikeMode(), parameter.isNotLike(), ps, ++index, parameter.getValue(), jdbcType);
                return index;
            }
            return this.setParameters(ps, index, parameter.getValue(), typeHandler, parameter.getJdbcType());
        }
        if (value instanceof MybatisParameter) {
            MybatisParameter parameter = (MybatisParameter)value;
            Object realValue = parameter.getValue();
            if (realValue == null) {
                return this.setParameters(ps, index, null, null, null);
            }
            if (parameter.getTypeHandler() == null) {
                return this.setParameters(ps, index, parameter.getValue(), null, parameter.getJdbcType());
            }
            if (parameter.getTypeHandler() == null || parameter.getTypeHandler() == UnknownTypeHandler.class) {
                return this.setParameters(ps, index, parameter.getValue(), null, parameter.getJdbcType());
            }
            if (typeHandler == null || parameter.getTypeHandler() != typeHandler.getClass()) {
                typeHandler = MybatisTypeHandlerUtil.getTypeHandler(this.configuration, realValue.getClass(), parameter.getTypeHandler());
            }
            return this.setParameters(ps, index, parameter.getValue(), typeHandler, parameter.getJdbcType());
        }
        if (typeHandler == null) {
            typeHandler = this.configuration.getTypeHandlerRegistry().getTypeHandler(value.getClass());
        }
        if (typeHandler == null) {
            ps.setObject(++index, value);
            return index;
        }
        typeHandler.setParameter(ps, ++index, value, jdbcType);
        return index;
    }

    public void setParameters(PreparedStatement ps) throws SQLException {
        Object[] params = this.parameterContext.getParameters();
        int length = params.length;
        int index = 0;
        for (int i = 0; i < length; ++i) {
            Object value = params[i];
            index = this.setParameters(ps, index, value, null, null);
        }
    }
}

