/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.logicDelete;

import cn.xbatis.core.XbatisConfig;
import cn.xbatis.core.db.reflect.TableFieldInfo;
import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.logicDelete.LogicDeleteSwitch;
import cn.xbatis.core.mybatis.mapper.BasicMapper;
import cn.xbatis.core.sql.MybatisCmdFactory;
import cn.xbatis.core.sql.executor.BaseUpdate;
import cn.xbatis.core.sql.executor.MpTable;
import cn.xbatis.core.sql.executor.Update;
import cn.xbatis.db.annotations.LogicDelete;
import db.sql.api.Cmd;
import db.sql.api.cmd.basic.ITable;
import db.sql.api.impl.cmd.basic.Table;
import db.sql.api.impl.cmd.basic.TableField;
import db.sql.api.impl.cmd.struct.ConditionChain;
import db.sql.api.impl.cmd.struct.Where;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Objects;
import java.util.function.Supplier;

public final class LogicDeleteUtil {
    public static <T> T execute(boolean state, Supplier<T> supplier) {
        try (LogicDeleteSwitch ignore = LogicDeleteSwitch.with(state);){
            T t = supplier.get();
            return t;
        }
    }

    public static void execute(boolean state, Runnable runnable) {
        try (LogicDeleteSwitch ignore = LogicDeleteSwitch.with(state);){
            runnable.run();
        }
    }

    public static boolean isNeedLogicDelete(TableInfo tableInfo) {
        return XbatisConfig.isLogicDeleteSwitchOpen() && Objects.nonNull(tableInfo.getLogicDeleteFieldInfo());
    }

    public static Object getLogicAfterValue(TableFieldInfo logicDeleteFieldInfo) {
        LogicDelete logicDelete = logicDeleteFieldInfo.getLogicDeleteAnnotation();
        Class<?> type = logicDeleteFieldInfo.getFieldInfo().getTypeClass();
        Object value = XbatisConfig.getDefaultValue(logicDeleteFieldInfo.getFieldInfo().getClazz(), type, logicDelete.afterValue());
        if (value == null) {
            throw new RuntimeException("Unable to obtain deleted value\uff0cplease use XbatisConfig.setDefaultValue(\"" + logicDelete.afterValue() + "\") to resolve it");
        }
        return value;
    }

    public static Object getLogicDeleteTimeValue(TableInfo tableInfo) {
        String deleteTimeFieldName = tableInfo.getLogicDeleteFieldInfo().getLogicDeleteAnnotation().deleteTimeField();
        TableFieldInfo deleteTimeField = tableInfo.getFieldInfo(deleteTimeFieldName);
        if (Objects.isNull(deleteTimeField)) {
            throw new RuntimeException("the attribute: " + deleteTimeFieldName + " in @LogicDelete is not found in class: " + tableInfo.getType().getName());
        }
        Class<?> type = deleteTimeField.getFieldInfo().getTypeClass();
        if (type == LocalDateTime.class) {
            return LocalDateTime.now();
        }
        if (type == Date.class) {
            return new Date();
        }
        if (type == Long.class) {
            return System.currentTimeMillis();
        }
        if (type == Integer.class) {
            return (int)(System.currentTimeMillis() / 1000L);
        }
        throw new RuntimeException("Unsupported types");
    }

    public static void addLogicDeleteUpdateSets(BaseUpdate baseUpdate, TableInfo tableInfo) {
        Class<?> entityType = tableInfo.getType();
        TableField logicDeleteTableField = baseUpdate.$().field(entityType, tableInfo.getLogicDeleteFieldInfo().getField().getName(), 1);
        baseUpdate.set(logicDeleteTableField, LogicDeleteUtil.getLogicAfterValue(tableInfo.getLogicDeleteFieldInfo()));
        String deleteTimeFieldName = tableInfo.getLogicDeleteFieldInfo().getLogicDeleteAnnotation().deleteTimeField();
        if (!"".equals(deleteTimeFieldName)) {
            TableField logicDeleteTimeTableField = baseUpdate.$().field(entityType, deleteTimeFieldName, 1);
            baseUpdate.set(logicDeleteTimeTableField, LogicDeleteUtil.getLogicDeleteTimeValue(tableInfo));
        }
    }

    public static int logicDelete(BasicMapper mapper, TableInfo tableInfo, Where where) {
        Update update = new Update(where);
        ((Update)update.update((ITable[])new Table[]{(Table)((MybatisCmdFactory)update.$()).table(tableInfo.getType())})).connect(self -> LogicDeleteUtil.addLogicDeleteUpdateSets(self, tableInfo));
        return mapper.update(update);
    }

    public static void addLogicDeleteCondition(MpTable table, ConditionChain conditionChain) {
        if (!XbatisConfig.isLogicDeleteSwitchOpen()) {
            return;
        }
        TableInfo tableInfo = table.getTableInfo();
        if (Objects.isNull(tableInfo.getLogicDeleteFieldInfo())) {
            return;
        }
        Object logicBeforeValue = tableInfo.getLogicDeleteFieldInfo().getLogicDeleteInitValue();
        TableField tableField = table.$(tableInfo.getLogicDeleteFieldInfo().getColumnName());
        if (Objects.isNull(logicBeforeValue)) {
            conditionChain.isNull((Cmd)tableField);
        } else {
            conditionChain.eq((Cmd)tableField, logicBeforeValue);
        }
    }
}

