/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.incrementer;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;

public class IdWorker {
    public static final IdWorker INSTANCE = new IdWorker();
    private static final long WORKER_ID_BITS = 5L;
    private static final long DATA_CENTER_ID_BITS = 5L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long MAX_WORKER_ID = 31L;
    private static final long MAX_DATA_CENTER_ID = 31L;
    private static final long SEQUENCE_MASK = 4095L;
    private static final long WORK_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 17L;
    private static final long TIMESTAMP_SHIFT = 22L;
    private static final long idWorkerStartTime = 1700150400000L;
    private static final long offsetPeriod = 5L;
    private final long workerId;
    private final long dataCenterId;
    protected InetAddress address;
    private long sequence;
    private long lastTimeMillis = -1L;

    public IdWorker() {
        this(null);
    }

    public IdWorker(InetAddress address) {
        this.address = address;
        this.dataCenterId = this.getDataCenterId(31L);
        this.workerId = this.getWorkerId(this.dataCenterId, 31L);
    }

    public IdWorker(long workerId, long dataCenterId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException("workerId must be greater than 0 and less than 31");
        }
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException("dataCenterId must be greater than 0 and less than 31");
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
    }

    protected long getWorkerId(long dataCenterId, long maxWorkerId) {
        StringBuilder mpId = new StringBuilder();
        mpId.append(dataCenterId);
        String name = ManagementFactory.getRuntimeMXBean().getName();
        if (name != null && !name.isEmpty()) {
            mpId.append(name.split("@")[0]);
        }
        return (long)(mpId.toString().hashCode() & 0xFFFF) % (maxWorkerId + 1L);
    }

    protected long getDataCenterId(long maxDataCenterId) {
        long id = 0L;
        try {
            NetworkInterface network;
            if (this.address == null) {
                this.address = InetAddress.getLocalHost();
            }
            if (null == (network = NetworkInterface.getByInetAddress(this.address))) {
                id = 1L;
            } else {
                byte[] mac = network.getHardwareAddress();
                if (null != mac) {
                    id = (0xFFL & (long)mac[mac.length - 2] | 0xFF00L & (long)mac[mac.length - 1] << 8) >> 6;
                    id %= maxDataCenterId + 1L;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("dataCenterId: " + e.getMessage(), e);
        }
        return id;
    }

    public synchronized long nextId() {
        long currentTimeMillis;
        block8: {
            currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis < this.lastTimeMillis) {
                long offset = this.lastTimeMillis - currentTimeMillis;
                if (offset <= 5L) {
                    try {
                        this.wait(offset << 1);
                        currentTimeMillis = System.currentTimeMillis();
                        if (currentTimeMillis < this.lastTimeMillis) {
                            throw new RuntimeException("Clock moved backwards, please check the time. Current timestamp: " + currentTimeMillis + ", last used timestamp: " + this.lastTimeMillis);
                        }
                        break block8;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new RuntimeException("Clock moved backwards, please check the time. Current timestamp: " + currentTimeMillis + ", last used timestamp: " + this.lastTimeMillis);
            }
        }
        if (currentTimeMillis == this.lastTimeMillis) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                currentTimeMillis = this.tilNextMillis(this.lastTimeMillis);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimeMillis = currentTimeMillis;
        return currentTimeMillis - 1700150400000L << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long currentTimeMillis = System.currentTimeMillis();
        while (currentTimeMillis <= lastTimestamp) {
            currentTimeMillis = System.currentTimeMillis();
        }
        return currentTimeMillis;
    }
}

