/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core;

import cn.xbatis.core.logicDelete.LogicDeleteSwitch;
import cn.xbatis.core.mybatis.mapper.BasicMapper;
import cn.xbatis.core.sql.SQLBuilder;
import cn.xbatis.core.sql.XbatisSQLBuilder;
import cn.xbatis.core.sql.listener.ForeignKeySQLListener;
import cn.xbatis.core.sql.listener.LogicDeleteSQLListener;
import cn.xbatis.core.sql.listener.TenantSQLListener;
import cn.xbatis.core.util.TypeConvertUtil;
import db.sql.api.DbType;
import db.sql.api.cmd.listener.SQLListener;
import db.sql.api.impl.paging.IPagingProcessor;
import db.sql.api.impl.paging.PagingProcessorFactory;
import java.lang.reflect.Array;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;

public final class XbatisConfig {
    private static final Map<String, Object> CACHE = new ConcurrentHashMap<String, Object>();
    private static final String COLUMN_UNDERLINE = "columnUnderline";
    private static final String TABLE_UNDERLINE = "tableUnderline";
    private static final String DEFAULT_BATCH_SIZE = "defaultBatchSize";
    private static final String SQL_BUILDER = "SQLBuilder";
    private static final String LOGIC_DELETE_SWITCH = "logicDeleteSwitch";
    private static final String DEFAULT_VALUE_MANAGER = "defaultValueManager";
    private static final String SINGLE_MAPPER_CLASS = "singleMapperClass";
    private static final List<SQLListener> SQL_LISTENER = new ArrayList<SQLListener>();
    private static volatile DbType DEFAULT_DB_TYPE;

    private XbatisConfig() {
    }

    public static DbType getDefaultDbType() {
        return DEFAULT_DB_TYPE;
    }

    public static void setDefaultDbType(DbType defaultDbType) {
        DEFAULT_DB_TYPE = defaultDbType;
    }

    public static boolean isColumnUnderline() {
        return (Boolean)CACHE.computeIfAbsent(COLUMN_UNDERLINE, key -> true);
    }

    public static void setColumnUnderline(boolean bool) {
        CACHE.putIfAbsent(COLUMN_UNDERLINE, bool);
    }

    public static boolean isTableUnderline() {
        return (Boolean)CACHE.computeIfAbsent(TABLE_UNDERLINE, key -> true);
    }

    public static void setTableUnderline(boolean bool) {
        CACHE.putIfAbsent(TABLE_UNDERLINE, bool);
    }

    public static int getDefaultBatchSize() {
        return (Integer)CACHE.computeIfAbsent(DEFAULT_BATCH_SIZE, key -> 1000);
    }

    public static void setDefaultBatchSize(int defaultBatchSize) {
        if (defaultBatchSize < 1) {
            throw new RuntimeException("defaultBatchSize can't less 1");
        }
        CACHE.put(DEFAULT_BATCH_SIZE, defaultBatchSize);
    }

    public static SQLBuilder getSQLBuilder() {
        return (SQLBuilder)CACHE.computeIfAbsent(SQL_BUILDER, key -> new XbatisSQLBuilder());
    }

    public static void setSQLBuilder(SQLBuilder sqlBuilder) {
        CACHE.put(SQL_BUILDER, sqlBuilder);
    }

    public static boolean isLogicDeleteSwitchOpen() {
        Boolean state = LogicDeleteSwitch.getState();
        if (state != null) {
            return state;
        }
        return (Boolean)CACHE.computeIfAbsent(LOGIC_DELETE_SWITCH, key -> true);
    }

    public static void setLogicDeleteSwitch(boolean bool) {
        CACHE.putIfAbsent(LOGIC_DELETE_SWITCH, bool);
    }

    public static boolean isDefaultValueKeyFormat(String key) {
        return key.startsWith("{") && key.endsWith("}");
    }

    public static void setDefaultValue(String key, BiFunction<Class<?>, Class<?>, Object> f) {
        XbatisConfig.checkDefaultValueKey(key);
        ((Map)CACHE.get(DEFAULT_VALUE_MANAGER)).computeIfAbsent(key, mapKey -> f);
    }

    private static void checkDefaultValueKey(String key) {
        if (!XbatisConfig.isDefaultValueKeyFormat(key)) {
            throw new RuntimeException("key must start with '{' and end with '}'");
        }
    }

    public static <T> T getDefaultValue(Class<?> clazz, Class<T> type, String key) {
        if (!XbatisConfig.isDefaultValueKeyFormat(key)) {
            return TypeConvertUtil.convert(key, type);
        }
        Map map = (Map)CACHE.get(DEFAULT_VALUE_MANAGER);
        BiFunction f = (BiFunction)map.get(key);
        if (f == null) {
            throw new RuntimeException("default value key:  " + key + " not set");
        }
        return (T)f.apply(clazz, type);
    }

    public static Class<? extends BasicMapper> getSingleMapperClass() {
        return (Class)CACHE.computeIfAbsent(SINGLE_MAPPER_CLASS, key -> BasicMapper.class);
    }

    public static void setSingleMapperClass(Class<? extends BasicMapper> singleMapperClass) {
        CACHE.putIfAbsent(SINGLE_MAPPER_CLASS, singleMapperClass);
    }

    public static void addSQLListener(SQLListener sqlListener) {
        SQL_LISTENER.add(sqlListener);
    }

    public static <T extends SQLListener> void removeSQLListener(Class<T> type) {
        Iterator<SQLListener> iterator = SQL_LISTENER.iterator();
        while (iterator.hasNext()) {
            if (!type.isAssignableFrom(iterator.next().getClass())) continue;
            iterator.remove();
        }
    }

    public static List<SQLListener> getSQLListeners() {
        return Collections.unmodifiableList(SQL_LISTENER);
    }

    public static void setPagingProcessor(DbType dbType, IPagingProcessor pagingProcessor) {
        PagingProcessorFactory.setProcessor((DbType)dbType, (IPagingProcessor)pagingProcessor);
    }

    public static IPagingProcessor getPagingProcessor(DbType dbType) {
        return PagingProcessorFactory.getProcessor((DbType)dbType);
    }

    static {
        SQL_LISTENER.add(new ForeignKeySQLListener());
        SQL_LISTENER.add(new TenantSQLListener());
        SQL_LISTENER.add(new LogicDeleteSQLListener());
        ConcurrentHashMap<String, BiFunction<Class, Class, Object>> defaultValueMap = new ConcurrentHashMap<String, BiFunction<Class, Class, Object>>();
        defaultValueMap.put("{BLANK}", (source, type) -> {
            if (type == String.class) {
                return "";
            }
            if (type.isArray()) {
                return Array.newInstance(type, 0);
            }
            if (List.class.isAssignableFrom((Class<?>)type)) {
                return Collections.EMPTY_LIST;
            }
            if (Set.class.isAssignableFrom((Class<?>)type)) {
                return Collections.EMPTY_SET;
            }
            if (Map.class.isAssignableFrom((Class<?>)type)) {
                return Collections.EMPTY_MAP;
            }
            throw new RuntimeException("Inconsistent types\uff1a" + type);
        });
        defaultValueMap.put("{NOW}", (source, type) -> {
            if (type == LocalDateTime.class) {
                return LocalDateTime.now();
            }
            if (type == LocalDate.class) {
                return LocalDate.now();
            }
            if (type == LocalTime.class) {
                return LocalTime.now();
            }
            if (type == Date.class) {
                return new Date();
            }
            if (type == Long.class) {
                return System.currentTimeMillis();
            }
            if (type == Integer.class) {
                return (int)(System.currentTimeMillis() / 1000L);
            }
            throw new RuntimeException("Inconsistent types\uff1a" + type);
        });
        CACHE.put(DEFAULT_VALUE_MANAGER, defaultValueMap);
    }
}

