/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.util;

import cn.xbatis.db.annotations.Ignore;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.ibatis.reflection.TypeParameterResolver;

public final class FieldUtil {
    public static boolean isResultMappingField(Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        if (Modifier.isFinal(field.getModifiers())) {
            return false;
        }
        return !field.isAnnotationPresent(Ignore.class);
    }

    private static boolean isIgnoreField(Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        if (Modifier.isFinal(field.getModifiers())) {
            return false;
        }
        return !field.isAnnotationPresent(Ignore.class);
    }

    public static List<Field> getResultMappingFields(Class clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        HashSet<String> fieldNameSet = new HashSet<String>();
        HashSet<String> ignoreFieldNameSet = new HashSet<String>();
        for (Class parseClass = clazz; parseClass != null; parseClass = parseClass.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = parseClass.getDeclaredFields()) {
                if (FieldUtil.isResultMappingField(field)) {
                    if (fieldNameSet.contains(field.getName()) || ignoreFieldNameSet.contains(field.getName())) continue;
                    fieldNameSet.add(field.getName());
                    fieldList.add(field);
                    continue;
                }
                if (!FieldUtil.isIgnoreField(field)) continue;
                ignoreFieldNameSet.add(field.getName());
            }
        }
        return fieldList;
    }

    public static Class<?> getFieldType(Class clazz, Field field) {
        Type type = TypeParameterResolver.resolveFieldType((Field)field, (Type)clazz);
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
        return (Class)type;
    }

    public static Class<?> getFieldFinalType(Class clazz, Field field) {
        Type type = TypeParameterResolver.resolveFieldType((Field)field, (Type)clazz);
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return (Class)type;
    }
}

