/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.sql.util;

import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.sql.MybatisCmdFactory;
import cn.xbatis.core.sql.executor.BaseQuery;
import cn.xbatis.core.sql.executor.Query;
import cn.xbatis.core.sql.util.WhereUtil;
import db.sql.api.Getter;
import db.sql.api.impl.cmd.struct.Where;
import db.sql.api.impl.tookit.OptimizeOptions;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;

public final class QueryUtil {
    public static <T, Q extends BaseQuery<Q, T>> void fillQueryDefault(Q q, TableInfo tableInfo) {
        QueryUtil.fillQueryDefault(q, tableInfo, null);
    }

    public static <T, Q extends BaseQuery<Q, T>> void fillQueryDefault(Q q, TableInfo tableInfo, Getter<T>[] selectFields) {
        if (Objects.nonNull(selectFields) && selectFields.length > 0) {
            q.select(selectFields);
        } else if (Objects.isNull(q.getSelect())) {
            q.select(tableInfo.getType());
        }
        if (Objects.isNull(q.getFrom())) {
            q.from(tableInfo.getType());
        }
        if (Objects.isNull(q.getReturnType())) {
            q.setReturnType(tableInfo.getType());
        }
    }

    public static <T, Q extends BaseQuery<Q, T>> Q buildQuery(Consumer<Q> consumer) {
        return QueryUtil.buildQuery(WhereUtil.create(), consumer);
    }

    public static <T, Q extends BaseQuery<Q, T>> Q buildQuery(TableInfo tableInfo) {
        return Query.create().from(tableInfo.getType());
    }

    public static <T, Q extends BaseQuery<Q, T>> Q buildQuery(Where where, Consumer<Q> consumer) {
        Query query = Query.create(where);
        if (Objects.nonNull(consumer)) {
            consumer.accept(query);
        }
        return (Q)query;
    }

    public static <T, Q extends BaseQuery<Q, T>> Q buildQuery(TableInfo tableInfo, Consumer<Q> consumer) {
        return QueryUtil.buildQuery(tableInfo, WhereUtil.create(tableInfo), consumer);
    }

    public static <T, Q extends BaseQuery<Q, T>> Q buildQuery(TableInfo tableInfo, Where where) {
        return QueryUtil.buildQuery(tableInfo, where, null);
    }

    public static <T, Q extends BaseQuery<Q, T>> Q buildQuery(TableInfo tableInfo, Where where, Consumer<Q> consumer) {
        Q query = QueryUtil.buildQuery(where, consumer);
        ((MybatisCmdFactory)query.$()).cacheTableInfo(tableInfo);
        return query;
    }

    public static <ID extends Serializable, E> BaseQuery<? extends BaseQuery, E> buildIdsQuery(TableInfo tableInfo, Collection<ID> ids) {
        return QueryUtil.buildIdsQuery(tableInfo, ids, null);
    }

    public static <ID extends Serializable, T, Q extends BaseQuery<Q, T>> Q buildIdsQuery(TableInfo tableInfo, Collection<ID> ids, Consumer<Q> consumer) {
        Where where = WhereUtil.create(tableInfo);
        WhereUtil.appendIdsWhere(where, tableInfo, ids);
        return QueryUtil.buildNoOptimizationQuery(tableInfo, where, consumer);
    }

    public static <ID extends Serializable, E> BaseQuery<? extends BaseQuery, E> buildIdsQuery(TableInfo tableInfo, ID[] ids) {
        return QueryUtil.buildIdsQuery((TableInfo)tableInfo, ids, null);
    }

    public static <ID extends Serializable, T, Q extends BaseQuery<Q, T>> Q buildIdsQuery(TableInfo tableInfo, ID[] ids, Consumer<Q> consumer) {
        Where where = WhereUtil.create(tableInfo);
        WhereUtil.appendIdsWhere(where, tableInfo, ids);
        return QueryUtil.buildNoOptimizationQuery(tableInfo, where, consumer);
    }

    public static <ID extends Serializable, E> BaseQuery<? extends BaseQuery, E> buildIdQuery(TableInfo tableInfo, ID id) {
        return QueryUtil.buildIdQuery(tableInfo, id, null);
    }

    public static <ID extends Serializable, T, Q extends BaseQuery<Q, T>> Q buildIdQuery(TableInfo tableInfo, ID id, Consumer<Q> consumer) {
        Where where = WhereUtil.create(tableInfo);
        WhereUtil.appendIdWhere(where, tableInfo, id);
        return QueryUtil.buildNoOptimizationQuery(tableInfo, where, consumer);
    }

    public static <T, Q extends BaseQuery<Q, T>> Q buildNoOptimizationQuery(TableInfo tableInfo) {
        return QueryUtil.buildNoOptimizationQuery(tableInfo, null, null);
    }

    public static <T, Q extends BaseQuery<Q, T>> Q buildNoOptimizationQuery(TableInfo tableInfo, Consumer<Q> consumer) {
        return QueryUtil.buildNoOptimizationQuery(tableInfo, null, consumer);
    }

    public static <T, Q extends BaseQuery<Q, T>> Q buildNoOptimizationQuery(TableInfo tableInfo, Where where) {
        return QueryUtil.buildNoOptimizationQuery(tableInfo, where, null);
    }

    public static <T, Q extends BaseQuery<Q, T>> Q buildNoOptimizationQuery(TableInfo tableInfo, Where where, Consumer<Q> consumer) {
        Q query = QueryUtil.buildQuery(tableInfo, where, consumer);
        ((BaseQuery)query).optimizeOptions(OptimizeOptions::disableAll);
        return query;
    }
}

