/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.sql.executor.chain;

import cn.xbatis.core.mybatis.mapper.BaseMapper;
import cn.xbatis.core.mybatis.mapper.MybatisMapper;
import cn.xbatis.core.sql.executor.BaseQuery;
import cn.xbatis.core.sql.util.SelectClassUtil;
import cn.xbatis.page.IPager;
import db.sql.api.GetterFun;
import db.sql.api.impl.cmd.struct.Where;
import db.sql.api.tookit.LambdaUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.ibatis.cursor.Cursor;

public class QueryChain<T>
extends BaseQuery<QueryChain<T>, T> {
    protected BaseMapper mapper;
    protected boolean autoSelect = true;
    protected Class<?> entityType;

    protected QueryChain() {
    }

    public QueryChain(MybatisMapper<T> mapper) {
        this.mapper = mapper;
    }

    public QueryChain(MybatisMapper<T> mapper, Where where) {
        super(where);
        this.mapper = mapper;
    }

    public QueryChain(BaseMapper mapper, Class<T> entityType) {
        this.mapper = mapper;
        this.entityType = entityType;
    }

    public QueryChain(BaseMapper mapper, Class<T> entityType, Where where) {
        super(where);
        this.mapper = mapper;
        this.entityType = entityType;
    }

    public static <T> QueryChain<T> create() {
        return new QueryChain<T>();
    }

    public static <T> QueryChain<T> of(MybatisMapper<T> mapper) {
        return new QueryChain<T>(mapper);
    }

    public static <T> QueryChain<T> of(MybatisMapper<T> mapper, Where where) {
        return new QueryChain<T>(mapper, where);
    }

    public static <T> QueryChain<T> of(BaseMapper mapper, Class<T> entityType) {
        return new QueryChain<T>(mapper, entityType);
    }

    public static <T> QueryChain<T> of(BaseMapper mapper, Class<T> entityType, Where where) {
        return new QueryChain<T>(mapper, entityType, where);
    }

    protected Class<?> getEntityType() {
        if (this.entityType != null) {
            return this.entityType;
        }
        if (!(this.mapper instanceof MybatisMapper)) {
            throw new RuntimeException("you need specify entityType");
        }
        this.entityType = ((MybatisMapper)this.mapper).getEntityType();
        return this.entityType;
    }

    public QueryChain<T> disableAutoSelect() {
        this.autoSelect = false;
        return this;
    }

    public <T2> QueryChain<T2> returnType(Class<T2> returnType) {
        return (QueryChain)super.setReturnType(returnType);
    }

    public <T2> QueryChain<T2> returnType(Class<T2> returnType, Consumer<T2> consumer) {
        return (QueryChain)super.setReturnType(returnType, consumer);
    }

    public <V> QueryChain<Map<String, V>> returnMap() {
        return (QueryChain)super.setReturnType(Map.class);
    }

    private void setDefault() {
        this.setDefault(false);
    }

    private void setDefault(boolean forCount) {
        if (this.autoSelect && Objects.isNull(this.select)) {
            if (forCount) {
                this.selectCountAll();
            } else {
                boolean hasSetSelect = false;
                if (Objects.nonNull(this.returnType)) {
                    hasSetSelect = SelectClassUtil.select(this, this.returnType);
                }
                if (!hasSetSelect) {
                    this.select(this.getEntityType());
                }
            }
        }
        if (Objects.isNull(this.from)) {
            this.from(this.getEntityType());
        }
        if (Objects.isNull(this.returnType)) {
            this.returnType(this.getEntityType());
        }
    }

    private void checkAndSetMapper(BaseMapper mapper) {
        if (Objects.isNull(this.mapper)) {
            this.mapper = mapper;
            return;
        }
        if (this.mapper == mapper) {
            return;
        }
        throw new RuntimeException(" the mapper is already set, can't use another mapper");
    }

    public QueryChain<T> withMapper(MybatisMapper<?> mapper) {
        this.checkAndSetMapper(mapper);
        return this;
    }

    public QueryChain<T> withMapper(BaseMapper mapper, Class<?> entityType) {
        this.checkAndSetMapper(mapper);
        this.entityType = entityType;
        return this;
    }

    public T get() {
        this.setDefault(false);
        return this.mapper.get(this);
    }

    public List<T> list() {
        this.setDefault(false);
        return this.mapper.list(this);
    }

    public Cursor<T> cursor() {
        this.setDefault(false);
        return this.mapper.cursor(this);
    }

    public Integer count() {
        if (this.select == null) {
            this.selectCountAll();
        }
        this.setDefault(true);
        return this.mapper.count(this);
    }

    public boolean exists() {
        if (this.select == null) {
            this.select1();
        }
        this.limit(1);
        this.setDefault();
        return this.mapper.exists(this);
    }

    public <P extends IPager<T>> P paging(P pager) {
        this.setDefault();
        return this.mapper.paging(this, pager);
    }

    public <K> Map<K, T> mapWithKey(GetterFun<T, K> mapKey) {
        this.setDefault();
        return this.mapper.mapWithKey(LambdaUtil.getName(mapKey), this);
    }
}

