/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.sql.executor.chain;

import cn.xbatis.core.mybatis.mapper.BaseMapper;
import cn.xbatis.core.mybatis.mapper.MybatisMapper;
import cn.xbatis.core.sql.executor.BaseInsert;
import cn.xbatis.core.sql.executor.Query;
import db.sql.api.Cmd;
import db.sql.api.Getter;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.GetterField;
import db.sql.api.cmd.executor.IQuery;
import db.sql.api.impl.cmd.basic.TableField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class InsertChain
extends BaseInsert<InsertChain> {
    private final Map<Getter<?>, Object> insertSelectFields = new HashMap();
    protected BaseMapper mapper;
    protected Class<?> entityType;

    protected InsertChain() {
    }

    public InsertChain(MybatisMapper<?> mapper) {
        this.mapper = mapper;
    }

    public InsertChain(BaseMapper mapper, Class<?> entityType) {
        this.mapper = mapper;
        this.entityType = entityType;
    }

    public static InsertChain of(MybatisMapper<?> mapper) {
        return new InsertChain(mapper);
    }

    public static InsertChain of(BaseMapper mapper, Class<?> entityType) {
        return new InsertChain(mapper, entityType);
    }

    public static InsertChain create() {
        return new InsertChain();
    }

    protected Class<?> getEntityType() {
        if (this.entityType != null) {
            return this.entityType;
        }
        if (!(this.mapper instanceof MybatisMapper)) {
            throw new RuntimeException("you need specify entityType");
        }
        this.entityType = ((MybatisMapper)this.mapper).getEntityType();
        return this.entityType;
    }

    public <T> InsertChain insertSelect(Getter<T> field, Cmd select) {
        this.insertSelectFields.put(field, select);
        return this;
    }

    public <T, T2> InsertChain insertSelect(Getter<T> field, Getter<T2> select) {
        this.insertSelectFields.put(field, select);
        return this;
    }

    public <T, T2> InsertChain insertSelect(Getter<T> field, Getter<T2> select, Function<TableField, Cmd> fun) {
        this.insertSelectFields.put(field, new SelectGetterFun<T2>(select, fun));
        return this;
    }

    public <T> InsertChain insertSelect(Getter<T> field, GetterField[] select, Function<TableField[], Cmd> fun) {
        this.insertSelectFields.put(field, new SelectGetterFieldsFun(select, fun));
        return this;
    }

    private void buildSelectQuery() {
        if (!this.insertSelectFields.isEmpty()) {
            ArrayList fields = new ArrayList();
            IQuery selectQuery = this.getInsertSelect().getSelectQuery();
            for (Map.Entry<Getter<?>, Object> entry : this.insertSelectFields.entrySet()) {
                fields.add(entry.getKey());
                if (entry.getValue() instanceof SelectGetterFun) {
                    SelectGetterFun selectGetterFun = (SelectGetterFun)entry.getValue();
                    selectQuery.select(selectGetterFun.field, selectGetterFun.fun);
                    continue;
                }
                if (entry.getValue() instanceof SelectGetterFieldsFun) {
                    SelectGetterFieldsFun selectGetterFieldsFun = (SelectGetterFieldsFun)entry.getValue();
                    selectQuery.select(selectGetterFieldsFun.fields, selectGetterFieldsFun.fun);
                    continue;
                }
                if (entry.getValue() instanceof Cmd) {
                    selectQuery.select((Cmd)entry.getValue());
                    continue;
                }
                selectQuery.select((Getter)entry.getValue());
            }
            this.fields(fields.toArray(new Getter[0]));
            this.fromSelect(selectQuery);
            this.insertSelectFields.clear();
        }
    }

    public InsertChain insertSelectQuery(Consumer<Query<?>> consumer) {
        if (!this.insertSelectFields.isEmpty()) {
            Query selectQuery = Query.create();
            this.fromSelect((IQuery)selectQuery);
            if (db.sql.api.impl.tookit.Objects.nonNull(consumer)) {
                consumer.accept(selectQuery);
            }
        }
        return this;
    }

    private void setDefault() {
        if (this.getInsertTable() == null) {
            this.insert(this.getEntityType());
        }
    }

    private void checkAndSetMapper(BaseMapper mapper) {
        if (Objects.isNull(this.mapper)) {
            this.mapper = mapper;
            return;
        }
        if (this.mapper == mapper) {
            return;
        }
        throw new RuntimeException(" the mapper is already set, can't use another mapper");
    }

    public InsertChain withMapper(MybatisMapper<?> mapper) {
        this.checkAndSetMapper(mapper);
        return this;
    }

    public InsertChain withMapper(BaseMapper mapper, Class<?> entityType) {
        this.checkAndSetMapper(mapper);
        this.entityType = entityType;
        return this;
    }

    public int execute() {
        this.setDefault();
        return this.mapper.save(this);
    }

    @Override
    public StringBuilder sql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        this.selectorExecute(context.getDbType());
        this.buildSelectQuery();
        return super.sql(module, parent, context, sqlBuilder);
    }

    private static class SelectGetterFieldsFun {
        public final GetterField[] fields;
        public final Function<TableField[], Cmd> fun;

        public SelectGetterFieldsFun(GetterField[] fields, Function<TableField[], Cmd> fun) {
            this.fields = fields;
            this.fun = fun;
        }
    }

    private static class SelectGetterFun<T> {
        public final Getter<T> field;
        public final Function<TableField, Cmd> fun;

        public SelectGetterFun(Getter<T> field, Function<TableField, Cmd> fun) {
            this.field = field;
            this.fun = fun;
        }
    }
}

