/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.sql.executor;

import cn.xbatis.core.sql.TableSplitUtil;
import cn.xbatis.core.sql.executor.MpTable;
import cn.xbatis.core.sql.executor.MpTableField;
import db.sql.api.cmd.basic.ICondition;
import db.sql.api.impl.cmd.ConditionFactory;
import db.sql.api.impl.cmd.basic.Condition;
import db.sql.api.impl.cmd.basic.Connector;
import db.sql.api.impl.cmd.struct.ConditionChain;

public class MybatisConditionChain
extends ConditionChain {
    public MybatisConditionChain(ConditionFactory conditionFactory) {
        super(conditionFactory);
    }

    public MybatisConditionChain(ConditionFactory conditionFactory, ConditionChain parent) {
        super(conditionFactory, parent);
    }

    protected void appendCondition(Connector connector, ICondition condition) {
        super.appendCondition(connector, condition);
        this.handleTableSplit(condition);
    }

    private void handleTableSplit(ICondition condition) {
        if (!(condition instanceof Condition)) {
            return;
        }
        Condition c = (Condition)condition;
        if (!(c.getField() instanceof MpTableField)) {
            return;
        }
        MpTableField tableField = (MpTableField)c.getField();
        if (!tableField.getTableFieldInfo().isTableSplitKey()) {
            return;
        }
        MpTable table = (MpTable)tableField.getTable();
        if (!table.getTableInfo().isSplitTable()) {
            return;
        }
        if (!table.getTableInfo().getTableName().equals(table.getName())) {
            return;
        }
        TableSplitUtil.splitHandle(table, c.getValue());
    }
}

