/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.typeHandler;

import cn.xbatis.core.mybatis.typeHandler.EnumSupport;
import cn.xbatis.core.util.TypeConvertUtil;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class EnumTypeHandler<E extends Enum<E>>
extends BaseTypeHandler<E> {
    private static final Map<Class<?>, Class<?>> CODE_TYPE_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, Map<Object, EnumSupport<?>>> TYPE_CODE_ENUM_CACHE = new ConcurrentHashMap();
    private final Class<E> type;
    private final boolean enumSupport;
    private final Class enumSupportType;

    public EnumTypeHandler(Class<E> type) {
        if (type == null) {
            throw new IllegalArgumentException("Type argument cannot be null");
        }
        this.type = type;
        this.enumSupport = EnumSupport.class.isAssignableFrom(type);
        this.enumSupportType = this.enumSupport ? CODE_TYPE_CACHE.computeIfAbsent(type, key -> {
            try {
                return type.getDeclaredMethod("getCode", new Class[0]).getReturnType();
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }) : null;
    }

    private Object getCode(E parameter) {
        if (this.enumSupport) {
            return ((EnumSupport)parameter).getCode();
        }
        return ((Enum)parameter).name();
    }

    private E readValue(ResultSet rs, String columnName) throws SQLException {
        Object value;
        if (this.enumSupport) {
            value = rs.getObject(columnName);
            value = TypeConvertUtil.convert(value, this.enumSupportType);
        } else {
            value = rs.getString(columnName);
        }
        return this.convert(value);
    }

    private E readValue(ResultSet rs, int columnIndex) throws SQLException {
        Object value;
        if (this.enumSupport) {
            value = rs.getObject(columnIndex);
            value = TypeConvertUtil.convert(value, this.enumSupportType);
        } else {
            value = rs.getString(columnIndex);
        }
        return this.convert(value);
    }

    private E readValue(CallableStatement cs, int columnIndex) throws SQLException {
        String value = this.enumSupport ? cs.getObject(columnIndex, this.enumSupportType) : cs.getString(columnIndex);
        return this.convert(value);
    }

    private E convert(Object value) {
        if (value == null) {
            return null;
        }
        if (this.enumSupport) {
            EnumSupport ev = (EnumSupport)TYPE_CODE_ENUM_CACHE.computeIfAbsent(this.type, key -> {
                EnumSupport[] es = (EnumSupport[])this.type.getEnumConstants();
                HashMap map = new HashMap();
                for (EnumSupport e : es) {
                    map.put(e.getCode(), e);
                }
                return map;
            }).get(value);
            if (Objects.isNull(ev)) {
                throw new IllegalArgumentException("No enum constant " + this.type.getCanonicalName() + " not included code : " + value);
            }
            return (E)((Enum)((Object)ev));
        }
        return Enum.valueOf(this.type, value.toString());
    }

    public void setNonNullParameter(PreparedStatement ps, int i, E parameter, JdbcType jdbcType) throws SQLException {
        Object code = this.getCode(parameter);
        if (jdbcType == null) {
            ps.setObject(i, code);
        } else {
            ps.setObject(i, code, jdbcType.TYPE_CODE);
        }
    }

    public E getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.readValue(rs, columnName);
    }

    public E getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.readValue(rs, columnIndex);
    }

    public E getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.readValue(cs, columnIndex);
    }
}

