/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper.mappers.utils;

import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.db.reflect.Tables;
import cn.xbatis.core.mybatis.mapper.BasicMapper;
import cn.xbatis.core.mybatis.mapper.context.EntityBatchInsertContext;
import cn.xbatis.core.mybatis.mapper.context.EntityInsertContext;
import cn.xbatis.core.mybatis.mapper.context.strategy.SaveBatchStrategy;
import cn.xbatis.core.mybatis.mapper.context.strategy.SaveStrategy;
import cn.xbatis.core.sql.executor.BaseInsert;
import cn.xbatis.core.sql.executor.Insert;
import java.util.Collection;
import java.util.Objects;

public final class SaveMethodUtil {
    public static <T> int save(BasicMapper basicMapper, TableInfo tableInfo, T entity) {
        return SaveMethodUtil.save(basicMapper, tableInfo, entity, new SaveStrategy());
    }

    public static <T> int save(BasicMapper basicMapper, TableInfo tableInfo, T entity, SaveStrategy<T> strategy) {
        return basicMapper.$saveEntity(new EntityInsertContext<T>(new Insert(), tableInfo, entity, strategy));
    }

    public static <T> int saveList(BasicMapper basicMapper, TableInfo tableInfo, Collection<T> list, SaveStrategy strategy) {
        if (Objects.isNull(list) || list.isEmpty()) {
            return 0;
        }
        int cnt = 0;
        for (T entity : list) {
            cnt += SaveMethodUtil.save(basicMapper, tableInfo, entity, strategy);
        }
        return cnt;
    }

    public static <E> int saveBatch(BasicMapper basicMapper, Collection<E> list) {
        if (Objects.isNull(list) || list.isEmpty()) {
            return 0;
        }
        TableInfo tableInfo = Tables.get(list.stream().findFirst().get().getClass());
        SaveBatchStrategy saveBatchStrategy = new SaveBatchStrategy();
        return SaveMethodUtil.saveBatch(basicMapper, tableInfo, list, saveBatchStrategy);
    }

    public static <E> int saveBatch(BasicMapper basicMapper, Collection<E> list, SaveBatchStrategy saveBatchStrategy) {
        if (Objects.isNull(list) || list.isEmpty()) {
            return 0;
        }
        TableInfo tableInfo = Tables.get(list.stream().findFirst().get().getClass());
        return SaveMethodUtil.saveBatch(basicMapper, tableInfo, list, saveBatchStrategy);
    }

    public static <E> int saveBatch(BasicMapper basicMapper, TableInfo tableInfo, Collection<E> list) {
        if (Objects.isNull(list) || list.isEmpty()) {
            return 0;
        }
        SaveBatchStrategy saveBatchStrategy = new SaveBatchStrategy();
        return SaveMethodUtil.saveBatch(basicMapper, tableInfo, list, saveBatchStrategy);
    }

    public static <T> int saveBatch(BasicMapper basicMapper, TableInfo tableInfo, Collection<T> list, SaveBatchStrategy<T> saveBatchStrategy) {
        if (Objects.isNull(list) || list.isEmpty()) {
            return 0;
        }
        return SaveMethodUtil.saveBatch(basicMapper, new Insert(), tableInfo, list, saveBatchStrategy);
    }

    public static <E> int saveBatch(BasicMapper basicMapper, BaseInsert<?> insert, TableInfo tableInfo, Collection<E> list, SaveBatchStrategy<E> saveBatchStrategy) {
        if (Objects.isNull(list) || list.isEmpty()) {
            return 0;
        }
        return basicMapper.$save(new EntityBatchInsertContext<E>(insert, tableInfo, list, saveBatchStrategy));
    }
}

