/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper.context;

import cn.xbatis.core.db.reflect.ModelFieldInfo;
import cn.xbatis.core.db.reflect.ModelInfo;
import cn.xbatis.core.mybatis.mapper.context.MybatisParameter;
import cn.xbatis.core.mybatis.mapper.context.strategy.UpdateStrategy;
import cn.xbatis.core.sql.MybatisCmdFactory;
import cn.xbatis.core.sql.executor.Update;
import cn.xbatis.core.sql.util.WhereUtil;
import cn.xbatis.core.tenant.TenantUtil;
import cn.xbatis.core.util.DefaultValueUtil;
import cn.xbatis.core.util.ModelInfoUtil;
import cn.xbatis.core.util.TypeConvertUtil;
import cn.xbatis.db.Model;
import db.sql.api.impl.cmd.Methods;
import db.sql.api.impl.cmd.basic.NULL;
import db.sql.api.impl.cmd.basic.Table;
import db.sql.api.impl.cmd.basic.TableField;
import db.sql.api.impl.cmd.struct.Where;
import db.sql.api.tookit.LambdaUtil;
import java.util.Objects;
import java.util.Set;

public class ModelUpdateCmdCreateUtil {
    public static <M extends Model<T>, T> Update create(ModelInfo modelInfo, M model, UpdateStrategy<M> updateStrategy) {
        Where where = updateStrategy.getWhere();
        if (where == null) {
            where = WhereUtil.create(modelInfo.getTableInfo());
        }
        Update update = new Update(where);
        if (updateStrategy.getOn() != null) {
            updateStrategy.getOn().accept(where);
        }
        boolean hasPutConditionBefore = where.hasContent();
        MybatisCmdFactory $ = (MybatisCmdFactory)update.$();
        Table table = (Table)$.table(modelInfo.getEntityType());
        boolean hasIdCondition = false;
        Set forceFields = LambdaUtil.getFieldNames(updateStrategy.getForceFields());
        for (ModelFieldInfo modelFieldInfo : modelInfo.getModelFieldInfos()) {
            boolean isForceUpdate = Objects.nonNull(forceFields) && forceFields.contains(modelFieldInfo.getField().getName());
            Object value = modelFieldInfo.getValue(model);
            if (modelFieldInfo.getTableFieldInfo().isTableId()) {
                if (!Objects.nonNull(value)) continue;
                if (update.$where().hasContent()) {
                    update.$where().extConditionChain().eq($.field(table, modelFieldInfo.getTableFieldInfo().getColumnName()), (Object)Methods.cmd((Object)value));
                } else {
                    update.$where().conditionChain().eq($.field(table, modelFieldInfo.getTableFieldInfo().getColumnName()), (Object)Methods.cmd((Object)value));
                }
                hasIdCondition = true;
                continue;
            }
            if (modelFieldInfo.getTableFieldInfo().isTenantId()) {
                if (!isForceUpdate) continue;
                if (Objects.isNull(value)) {
                    value = TenantUtil.getTenantId();
                    if (Objects.isNull(value)) continue;
                    TenantUtil.setTenantId(modelFieldInfo, model, value);
                }
            } else if (modelFieldInfo.getTableFieldInfo().isVersion()) {
                if (Objects.isNull(value)) continue;
                Object version = TypeConvertUtil.convert(Long.valueOf(1L) + 1L, modelFieldInfo.getField().getType());
                update.set((TableField)$.field(table, modelFieldInfo.getTableFieldInfo().getColumnName()), Methods.cmd(version));
                update.$where().extConditionChain().eq($.field(table, modelFieldInfo.getTableFieldInfo().getColumnName()), (Object)Methods.cmd((Object)value));
                ModelInfoUtil.setValue(modelFieldInfo, model, version);
                continue;
            }
            if (!"".equals(modelFieldInfo.getTableFieldInfo().getTableFieldAnnotation().updateDefaultValue())) {
                value = DefaultValueUtil.getAndSetUpdateDefaultValue(model, modelFieldInfo);
            }
            if (!isForceUpdate && !modelFieldInfo.getTableFieldInfo().getTableFieldAnnotation().update()) continue;
            if ((isForceUpdate || updateStrategy.isAllFieldUpdate()) && Objects.isNull(value)) {
                update.set((TableField)$.field(table, modelFieldInfo.getTableFieldInfo().getColumnName()), NULL.NULL);
                continue;
            }
            if (!Objects.nonNull(value)) continue;
            cn.xbatis.db.annotations.TableField tableField = modelFieldInfo.getTableFieldInfo().getTableFieldAnnotation();
            MybatisParameter mybatisParameter = new MybatisParameter(value, tableField.typeHandler(), tableField.jdbcType());
            update.set((TableField)$.field(table, modelFieldInfo.getTableFieldInfo().getColumnName()), Methods.cmd((Object)mybatisParameter));
        }
        if (!hasIdCondition && !hasPutConditionBefore) {
            throw new RuntimeException("update has no where condition content ");
        }
        update.update(table);
        return update;
    }
}

