/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper.context;

import cn.xbatis.core.db.reflect.ModelFieldInfo;
import cn.xbatis.core.db.reflect.ModelInfo;
import cn.xbatis.core.db.reflect.TableIds;
import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.incrementer.IdentifierGenerator;
import cn.xbatis.core.incrementer.IdentifierGeneratorFactory;
import cn.xbatis.core.mybatis.mapper.context.IdUtil;
import cn.xbatis.core.mybatis.mapper.context.MybatisParameter;
import cn.xbatis.core.mybatis.mapper.context.strategy.SaveStrategy;
import cn.xbatis.core.sql.MybatisCmdFactory;
import cn.xbatis.core.sql.executor.BaseInsert;
import cn.xbatis.core.sql.executor.Insert;
import cn.xbatis.core.sql.executor.MpTable;
import cn.xbatis.core.sql.executor.MpTableField;
import cn.xbatis.core.tenant.TenantUtil;
import cn.xbatis.core.util.DefaultValueUtil;
import cn.xbatis.core.util.ModelInfoUtil;
import cn.xbatis.core.util.TypeConvertUtil;
import cn.xbatis.db.IdAutoType;
import cn.xbatis.db.Model;
import cn.xbatis.db.annotations.TableField;
import cn.xbatis.db.annotations.TableId;
import db.sql.api.DbType;
import db.sql.api.cmd.basic.ITable;
import db.sql.api.impl.cmd.Methods;
import db.sql.api.impl.cmd.basic.NULL;
import java.util.ArrayList;
import java.util.Objects;

public class ModelInsertCreateUtil {
    public static <M extends Model<T>, T> BaseInsert<?> create(BaseInsert<?> insert, ModelInfo modelInfo, M insertData, SaveStrategy<T> saveStrategy, DbType dbType) {
        insert = insert == null ? new Insert() : insert;
        TableInfo tableInfo = modelInfo.getTableInfo();
        ((MybatisCmdFactory)insert.$()).cacheTableInfo(tableInfo);
        MpTable table = (MpTable)((MybatisCmdFactory)insert.$()).table(tableInfo.getType());
        insert.insert((ITable)table);
        TenantUtil.setTenantId(insertData);
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < modelInfo.getFieldSize(); ++i) {
            ModelFieldInfo modelFieldInfo = modelInfo.getModelFieldInfos().get(i);
            boolean isNeedInsert = false;
            Object value = modelFieldInfo.getValue(insertData);
            if (modelFieldInfo.getTableFieldInfo().isTableId()) {
                if (!IdUtil.isIdValueExists(value)) {
                    TableId tableId = TableIds.get(modelInfo.getTableInfo().getType(), dbType);
                    if (tableId.value() == IdAutoType.GENERATOR) {
                        isNeedInsert = true;
                        IdentifierGenerator identifierGenerator = IdentifierGeneratorFactory.getIdentifierGenerator(tableId.generatorName());
                        Object id = identifierGenerator.nextId(modelInfo.getType());
                        if (IdUtil.setId(insertData, modelFieldInfo, id)) {
                            value = id;
                        }
                    }
                } else {
                    isNeedInsert = true;
                }
            } else if (Objects.nonNull(value)) {
                isNeedInsert = true;
            } else if (modelFieldInfo.getTableFieldInfo().isLogicDelete()) {
                value = modelFieldInfo.getTableFieldInfo().getLogicDeleteInitValue();
                if (value != null) {
                    isNeedInsert = true;
                    ModelInfoUtil.setValue(modelFieldInfo, insertData, value);
                } else if (!"".equals(modelFieldInfo.getTableFieldInfo().getTableFieldAnnotation().defaultValue())) {
                    value = DefaultValueUtil.getAndSetDefaultValue(insertData, modelFieldInfo);
                    isNeedInsert = Objects.nonNull(value);
                }
            } else if (!"".equals(modelFieldInfo.getTableFieldInfo().getTableFieldAnnotation().defaultValue())) {
                value = DefaultValueUtil.getAndSetDefaultValue(insertData, modelFieldInfo);
                isNeedInsert = Objects.nonNull(value);
            } else if (modelFieldInfo.getTableFieldInfo().isVersion()) {
                isNeedInsert = true;
                value = TypeConvertUtil.convert(1, modelFieldInfo.getField().getType());
                ModelInfoUtil.setValue(modelFieldInfo, insertData, value);
            }
            if (!isNeedInsert && (saveStrategy.isAllFieldSave() || Objects.nonNull(saveStrategy.getForceFields()) && saveStrategy.getForceFields().contains(modelFieldInfo.getField().getName()))) {
                isNeedInsert = true;
                if (modelFieldInfo.getTableFieldInfo().isTableId() && value == null) {
                    isNeedInsert = false;
                }
            }
            if (!isNeedInsert) continue;
            insert.fields(new MpTableField(table, modelFieldInfo.getTableFieldInfo()));
            if (Objects.isNull(value)) {
                values.add(NULL.NULL);
                continue;
            }
            TableField tableField = modelFieldInfo.getTableFieldInfo().getTableFieldAnnotation();
            MybatisParameter mybatisParameter = new MybatisParameter(value, tableField.typeHandler(), tableField.jdbcType());
            values.add(Methods.cmd((Object)mybatisParameter));
        }
        insert.values(values);
        if (saveStrategy.getConflictAction() != null) {
            insert.conflictKeys(saveStrategy.getConflictKeys());
            insert.conflictKeys(saveStrategy.getConflictColumns());
            insert.onConflict(saveStrategy.getConflictAction());
        }
        return insert;
    }
}

