/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper.context;

import cn.xbatis.core.db.reflect.ModelInfo;
import cn.xbatis.core.mybatis.mapper.context.IdUtil;
import cn.xbatis.core.mybatis.mapper.context.ModelBatchInsertCreateUtil;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdInsertContext;
import cn.xbatis.core.mybatis.mapper.context.SetIdMethod;
import cn.xbatis.core.mybatis.mapper.context.strategy.SaveBatchStrategy;
import cn.xbatis.core.sql.executor.BaseInsert;
import cn.xbatis.db.Model;
import db.sql.api.DbType;
import java.util.Collection;
import java.util.Objects;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandler;

public class ModelBatchInsertContext<M extends Model>
extends SQLCmdInsertContext<BaseInsert, M[]>
implements SetIdMethod {
    private final SaveBatchStrategy<M> saveBatchStrategy;
    private final ModelInfo modelInfo;
    private final boolean idHasValue;
    private final BaseInsert<?> insert;

    public ModelBatchInsertContext(BaseInsert<?> insert, ModelInfo modelInfo, Collection<M> list, SaveBatchStrategy<M> saveBatchStrategy) {
        super(list.toArray(new Model[0]));
        this.insert = insert;
        this.modelInfo = modelInfo;
        this.saveBatchStrategy = saveBatchStrategy;
        this.entityType = modelInfo.getEntityType();
        this.idHasValue = IdUtil.isIdExists((Object)((Model[])this.getInsertData())[0], modelInfo.getIdFieldInfo());
    }

    @Override
    public void init(DbType dbType) {
        super.init(dbType);
        if (Objects.isNull(this.execution)) {
            this.execution = ModelBatchInsertCreateUtil.create(this.insert, (ModelInfo)this.modelInfo, (Model[])((Model[])this.getInsertData()), this.saveBatchStrategy, (DbType)dbType, (boolean)this.useBatchExecutor);
        }
    }

    @Override
    public void setId(Object id, int index) {
        IdUtil.setId((Object)((Model[])this.getInsertData())[index], this.modelInfo.getSingleIdFieldInfo(true), id);
    }

    @Override
    public boolean idHasValue() {
        return this.idHasValue;
    }

    @Override
    public int getInsertSize() {
        return ((Model[])this.getInsertData()).length;
    }

    @Override
    public Object getInsertData(int index) {
        return ((Model[])this.getInsertData())[index];
    }

    @Override
    public TypeHandler<?> getIdTypeHandler(Configuration configuration) {
        TypeHandler<?> typeHandler;
        if (Objects.nonNull(this.modelInfo.getIdFieldInfo()) && Objects.isNull(typeHandler = this.modelInfo.getIdFieldInfo().getTableFieldInfo().getTypeHandler())) {
            return configuration.getTypeHandlerRegistry().getTypeHandler(this.modelInfo.getIdFieldInfo().getFieldInfo().getTypeClass());
        }
        return null;
    }

    @Override
    public String getIdColumnName() {
        return this.modelInfo.getTableInfo().getIdFieldInfo().getColumnName();
    }
}

