/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper.context;

import cn.xbatis.core.db.reflect.TableFieldInfo;
import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.mybatis.mapper.context.MybatisParameter;
import cn.xbatis.core.mybatis.mapper.context.strategy.UpdateStrategy;
import cn.xbatis.core.sql.MybatisCmdFactory;
import cn.xbatis.core.sql.executor.Update;
import cn.xbatis.core.sql.util.WhereUtil;
import cn.xbatis.core.tenant.TenantUtil;
import cn.xbatis.core.util.DefaultValueUtil;
import cn.xbatis.core.util.TableInfoUtil;
import cn.xbatis.core.util.TypeConvertUtil;
import cn.xbatis.db.annotations.TableField;
import db.sql.api.impl.cmd.Methods;
import db.sql.api.impl.cmd.basic.NULL;
import db.sql.api.impl.cmd.basic.Table;
import db.sql.api.impl.cmd.struct.Where;
import db.sql.api.tookit.LambdaUtil;
import java.util.Objects;
import java.util.Set;

public class EntityUpdateCmdCreateUtil {
    public static Update create(TableInfo tableInfo, Object entity, UpdateStrategy<?> updateStrategy) {
        Where where = updateStrategy.getWhere();
        if (where == null) {
            where = WhereUtil.create(tableInfo);
        }
        Update update = new Update(where);
        if (updateStrategy.getOn() != null) {
            updateStrategy.getOn().accept(where);
        }
        boolean hasPutConditionBefore = where.hasContent();
        MybatisCmdFactory $ = (MybatisCmdFactory)update.$();
        Table table = (Table)$.table(entity.getClass());
        boolean hasIdCondition = false;
        Set forceFields = LambdaUtil.getFieldNames(updateStrategy.getForceFields());
        for (TableFieldInfo tableFieldInfo : tableInfo.getTableFieldInfos()) {
            boolean isForceUpdate;
            Object value = tableFieldInfo.getValue(entity);
            boolean bl = isForceUpdate = Objects.nonNull(forceFields) && forceFields.contains(tableFieldInfo.getField().getName());
            if (tableFieldInfo.isTableId()) {
                if (!Objects.nonNull(value)) continue;
                if (update.$where().hasContent()) {
                    update.$where().extConditionChain().eq($.field(table, tableFieldInfo.getColumnName()), (Object)Methods.cmd((Object)value));
                } else {
                    update.$where().conditionChain().eq($.field(table, tableFieldInfo.getColumnName()), (Object)Methods.cmd((Object)value));
                }
                hasIdCondition = true;
                continue;
            }
            if (tableFieldInfo.isTenantId()) {
                if (!isForceUpdate) continue;
                if (Objects.isNull(value)) {
                    value = TenantUtil.getTenantId();
                    if (Objects.isNull(value)) continue;
                    TenantUtil.setTenantId(tableFieldInfo, entity, value);
                }
            } else if (tableFieldInfo.isVersion()) {
                if (Objects.isNull(value)) continue;
                Object version = TypeConvertUtil.convert(Long.valueOf(1L) + 1L, tableFieldInfo.getField().getType());
                update.set((db.sql.api.impl.cmd.basic.TableField)$.field(table, tableFieldInfo.getColumnName()), Methods.cmd(version));
                update.$where().extConditionChain().eq($.field(table, tableFieldInfo.getColumnName()), (Object)Methods.cmd((Object)value));
                TableInfoUtil.setValue(tableFieldInfo, entity, version);
                continue;
            }
            if (!"".equals(tableFieldInfo.getTableFieldAnnotation().updateDefaultValue())) {
                value = DefaultValueUtil.getAndSetUpdateDefaultValue(entity, tableFieldInfo);
            }
            if (!isForceUpdate && !tableFieldInfo.getTableFieldAnnotation().update()) continue;
            if ((isForceUpdate || updateStrategy.isAllFieldUpdate()) && Objects.isNull(value)) {
                update.set((db.sql.api.impl.cmd.basic.TableField)$.field(table, tableFieldInfo.getColumnName()), NULL.NULL);
                continue;
            }
            if (!Objects.nonNull(value)) continue;
            TableField tableField = tableFieldInfo.getTableFieldAnnotation();
            MybatisParameter mybatisParameter = new MybatisParameter(value, tableField.typeHandler(), tableField.jdbcType());
            update.set((db.sql.api.impl.cmd.basic.TableField)$.field(table, tableFieldInfo.getColumnName()), Methods.cmd((Object)mybatisParameter));
        }
        if (!hasIdCondition && !hasPutConditionBefore) {
            throw new RuntimeException("update has no where condition content ");
        }
        update.update(table);
        return update;
    }
}

