/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.mapper.context;

import cn.xbatis.core.db.reflect.TableFieldInfo;
import cn.xbatis.core.db.reflect.TableIds;
import cn.xbatis.core.db.reflect.TableInfo;
import cn.xbatis.core.incrementer.IdentifierGenerator;
import cn.xbatis.core.incrementer.IdentifierGeneratorFactory;
import cn.xbatis.core.mybatis.mapper.context.IdUtil;
import cn.xbatis.core.mybatis.mapper.context.MybatisParameter;
import cn.xbatis.core.mybatis.mapper.context.strategy.SaveStrategy;
import cn.xbatis.core.sql.MybatisCmdFactory;
import cn.xbatis.core.sql.executor.BaseInsert;
import cn.xbatis.core.sql.executor.Insert;
import cn.xbatis.core.sql.executor.MpTable;
import cn.xbatis.core.sql.executor.MpTableField;
import cn.xbatis.core.tenant.TenantUtil;
import cn.xbatis.core.util.DefaultValueUtil;
import cn.xbatis.core.util.TableInfoUtil;
import cn.xbatis.core.util.TypeConvertUtil;
import cn.xbatis.db.IdAutoType;
import cn.xbatis.db.annotations.TableField;
import cn.xbatis.db.annotations.TableId;
import db.sql.api.DbType;
import db.sql.api.cmd.basic.ITable;
import db.sql.api.impl.cmd.Methods;
import db.sql.api.impl.cmd.basic.NULL;
import java.util.ArrayList;
import java.util.Objects;

public class EntityInsertCreateUtil {
    public static <T> BaseInsert<?> create(BaseInsert<?> insert, TableInfo tableInfo, T insertData, SaveStrategy<T> saveStrategy, DbType dbType) {
        insert = insert == null ? new Insert() : insert;
        ((MybatisCmdFactory)insert.$()).cacheTableInfo(tableInfo);
        MpTable table = (MpTable)((MybatisCmdFactory)insert.$()).table(tableInfo.getType());
        insert.insert((ITable)table);
        TenantUtil.setTenantId(tableInfo, insertData);
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < tableInfo.getFieldSize(); ++i) {
            TableFieldInfo tableFieldInfo = tableInfo.getTableFieldInfos().get(i);
            if (!tableFieldInfo.getTableFieldAnnotation().insert()) continue;
            boolean isNeedInsert = false;
            Object value = tableFieldInfo.getValue(insertData);
            if (tableFieldInfo.isTableId()) {
                if (!IdUtil.isIdValueExists(value)) {
                    TableId tableId = TableIds.get(insertData.getClass(), dbType);
                    if (tableId.value() == IdAutoType.GENERATOR) {
                        isNeedInsert = true;
                        IdentifierGenerator identifierGenerator = IdentifierGeneratorFactory.getIdentifierGenerator(tableId.generatorName());
                        Object id = identifierGenerator.nextId(tableInfo.getType());
                        if (IdUtil.setId(insertData, tableFieldInfo, id)) {
                            value = id;
                        }
                    }
                } else {
                    isNeedInsert = true;
                }
            } else if (Objects.nonNull(value)) {
                isNeedInsert = true;
            } else if (tableFieldInfo.isLogicDelete()) {
                value = tableFieldInfo.getLogicDeleteInitValue();
                if (value != null) {
                    isNeedInsert = true;
                    TableInfoUtil.setValue(tableFieldInfo, insertData, value);
                } else if (!"".equals(tableFieldInfo.getTableFieldAnnotation().defaultValue())) {
                    value = DefaultValueUtil.getAndSetDefaultValue(insertData, tableFieldInfo);
                    isNeedInsert = Objects.nonNull(value);
                }
            } else if (!"".equals(tableFieldInfo.getTableFieldAnnotation().defaultValue())) {
                value = DefaultValueUtil.getAndSetDefaultValue(insertData, tableFieldInfo);
                isNeedInsert = Objects.nonNull(value);
            } else if (tableFieldInfo.isVersion()) {
                isNeedInsert = true;
                value = TypeConvertUtil.convert(1, tableFieldInfo.getField().getType());
                TableInfoUtil.setValue(tableFieldInfo, insertData, value);
            }
            if (!isNeedInsert && (saveStrategy.isAllFieldSave() || Objects.nonNull(saveStrategy.getForceFields()) && saveStrategy.getForceFields().contains(tableFieldInfo.getField().getName()))) {
                isNeedInsert = true;
                if (tableFieldInfo.isTableId() && value == null) {
                    isNeedInsert = false;
                }
            }
            if (!isNeedInsert) continue;
            insert.fields(new MpTableField(table, tableFieldInfo));
            if (Objects.isNull(value)) {
                values.add(NULL.NULL);
                continue;
            }
            TableField tableField = tableFieldInfo.getTableFieldAnnotation();
            MybatisParameter mybatisParameter = new MybatisParameter(value, tableField.typeHandler(), tableField.jdbcType());
            values.add(Methods.cmd((Object)mybatisParameter));
        }
        insert.values(values);
        if (saveStrategy.getConflictAction() != null) {
            insert.conflictKeys(saveStrategy.getConflictKeys());
            insert.conflictKeys(saveStrategy.getConflictColumns());
            insert.onConflict(saveStrategy.getConflictAction());
        }
        return insert;
    }
}

