/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.executor;

import cn.xbatis.core.mybatis.configuration.MybatisConfiguration;
import cn.xbatis.core.mybatis.executor.MybatisIdUtil;
import cn.xbatis.core.mybatis.executor.TableIdGeneratorWrapper;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdInsertContext;
import cn.xbatis.core.mybatis.mapper.context.SQLCmdQueryContext;
import cn.xbatis.core.mybatis.mapping.ResultMapWrapper;
import cn.xbatis.core.mybatis.provider.SQLCmdSqlSource;
import cn.xbatis.core.sql.executor.BaseQuery;
import java.util.Collections;
import java.util.Objects;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;

public class DynamicsMappedStatement {
    public static final String MAPPED_STATEMENT_DB_KEY_NAME = "(dbType)";

    public static MappedStatement wrapMappedStatement(MappedStatement ms, Object parameterObject) {
        if (ms.getSqlCommandType() == SqlCommandType.INSERT) {
            return DynamicsMappedStatement.createInsertMappedStatement(ms, parameterObject);
        }
        if (ms.getSqlCommandType() != SqlCommandType.SELECT) {
            return ms;
        }
        if (!(parameterObject instanceof SQLCmdQueryContext)) {
            return ms;
        }
        if (((ResultMap)ms.getResultMaps().get(0)).getType() != Object.class && !ms.getId().endsWith("$mapWithKey")) {
            return ms;
        }
        SQLCmdQueryContext queryContext = (SQLCmdQueryContext)parameterObject;
        if (Objects.isNull(((BaseQuery)queryContext.getExecution()).getReturnType())) {
            return ms;
        }
        return DynamicsMappedStatement.createQueryMappedStatement(((BaseQuery)queryContext.getExecution()).getReturnType(), ms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MappedStatement createInsertMappedStatement(MappedStatement ms, Object parameterObject) {
        if (!(parameterObject instanceof SQLCmdInsertContext)) {
            return ms;
        }
        SQLCmdInsertContext sqlCmdInsertContext = (SQLCmdInsertContext)parameterObject;
        if (Objects.isNull(sqlCmdInsertContext.getEntityType())) {
            return ms;
        }
        SQLCmdSqlSource sqlCmdSqlSource = (SQLCmdSqlSource)ms.getSqlSource();
        String id = MybatisIdUtil.convertIdPath(sqlCmdInsertContext.getEntityType().getName()) + "-" + sqlCmdSqlSource.getDbType() + "-" + MAPPED_STATEMENT_DB_KEY_NAME + "@" + MybatisIdUtil.convertIdPath(ms.getId());
        if (ms.getConfiguration().hasStatement(id)) {
            return ms.getConfiguration().getMappedStatement(id);
        }
        MappedStatement.Builder msBuilder = new MappedStatement.Builder(ms.getConfiguration(), id, ms.getSqlSource(), ms.getSqlCommandType()).resource(ms.getResource()).resultMaps(ms.getResultMaps()).parameterMap(ms.getParameterMap()).keyGenerator(ms.getKeyGenerator()).fetchSize(ms.getFetchSize()).statementType(ms.getStatementType()).lang(ms.getLang()).timeout(ms.getTimeout()).useCache(ms.isUseCache()).cache(ms.getCache());
        MappedStatement newMappedStatement = msBuilder.build();
        try {
            TableIdGeneratorWrapper.addEntityKeyGenerator(newMappedStatement, sqlCmdInsertContext.getEntityType());
            if (ms.getConfiguration().hasStatement(id)) {
                return ms.getConfiguration().getMappedStatement(id);
            }
            String string = id.intern();
            synchronized (string) {
                if (ms.getConfiguration().hasStatement(id)) {
                    return ms.getConfiguration().getMappedStatement(id);
                }
                ms.getConfiguration().addMappedStatement(newMappedStatement);
                return newMappedStatement;
            }
        }
        catch (IllegalArgumentException e) {
            ms.getStatementLog().warn(e.getMessage());
            return ms;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MappedStatement createQueryMappedStatement(Class returnTypeClass, MappedStatement ms) {
        String id = MybatisIdUtil.convertIdPath(returnTypeClass.getName()) + "@" + MybatisIdUtil.convertIdPath(ms.getId());
        if (ms.getConfiguration().hasStatement(id)) {
            return ms.getConfiguration().getMappedStatement(id);
        }
        String resultMapId = returnTypeClass.getName();
        ResultMap resultMap = ms.getConfiguration().hasResultMap(resultMapId) ? ms.getConfiguration().getResultMap(resultMapId) : new ResultMap.Builder(ms.getConfiguration(), resultMapId, returnTypeClass, Collections.emptyList(), Boolean.valueOf(false)).build();
        MappedStatement.Builder msBuilder = new MappedStatement.Builder(ms.getConfiguration(), id, ms.getSqlSource(), ms.getSqlCommandType()).resource(ms.getResource()).resultMaps(ResultMapWrapper.replaceResultMap((MybatisConfiguration)ms.getConfiguration(), Collections.singletonList(resultMap))).parameterMap(ms.getParameterMap()).keyGenerator((KeyGenerator)NoKeyGenerator.INSTANCE).fetchSize(ms.getFetchSize()).statementType(ms.getStatementType()).lang(ms.getLang()).timeout(ms.getTimeout()).useCache(ms.isUseCache()).cache(ms.getCache());
        MappedStatement newMappedStatement = msBuilder.build();
        try {
            if (ms.getConfiguration().hasStatement(id)) {
                return ms.getConfiguration().getMappedStatement(id);
            }
            String string = id.intern();
            synchronized (string) {
                if (ms.getConfiguration().hasStatement(id)) {
                    return ms.getConfiguration().getMappedStatement(id);
                }
                ms.getConfiguration().addMappedStatement(newMappedStatement);
            }
        }
        catch (IllegalArgumentException e) {
            ms.getStatementLog().warn(e.getMessage());
        }
        return newMappedStatement;
    }
}

