/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.mybatis.configuration;

import cn.xbatis.core.util.DbTypeUtil;
import db.sql.api.DbType;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.VendorDatabaseIdProvider;

public class MybatisDatabaseIdProvider
extends VendorDatabaseIdProvider {
    private final boolean useDbTypeAutoProvider;

    public MybatisDatabaseIdProvider() {
        this(true);
    }

    public MybatisDatabaseIdProvider(boolean useDbTypeAutoProvider) {
        this.useDbTypeAutoProvider = useDbTypeAutoProvider;
        if (!useDbTypeAutoProvider) {
            super.setProperties(this.createDefaultProperties());
        }
    }

    public void setProperties(Properties p) {
        super.setProperties(p);
    }

    public String getDatabaseId(DataSource dataSource) {
        if (this.useDbTypeAutoProvider) {
            return DbTypeUtil.getDbType(dataSource).name();
        }
        return super.getDatabaseId(dataSource);
    }

    protected Properties createDefaultProperties() {
        Properties properties = new Properties();
        properties.put("H2", DbType.H2.name());
        properties.put("Oracle", DbType.ORACLE.name());
        properties.put("MySQL", DbType.MYSQL.name());
        properties.put("MariaDB", DbType.MARIA_DB.name());
        properties.put("SQL Server", DbType.SQL_SERVER.name());
        properties.put("PostgreSQL", DbType.PGSQL.name());
        properties.put("DM DBMS", DbType.DM.name());
        properties.put("Kingbase", DbType.KING_BASE.name());
        properties.put("SQLite", DbType.SQLITE.name());
        properties.put("DB2", DbType.DB2.name());
        properties.put("gauss", DbType.OPEN_GAUSS.name());
        properties.put("click", DbType.CLICK_HOUSE.name());
        return properties;
    }
}

