/*
 * Decompiled with CFR 0.152.
 */
package cn.xbatis.core.incrementer;

import cn.xbatis.core.incrementer.IdWorkerGenerator;
import cn.xbatis.core.incrementer.IdentifierGenerator;
import cn.xbatis.core.incrementer.UUIDGenerator;
import java.util.HashMap;
import java.util.Map;

public class IdentifierGeneratorFactory {
    private static final Map<String, IdentifierGenerator<?>> IDENTIFIER_GENERATOR_MAP = new HashMap();

    private IdentifierGeneratorFactory() {
    }

    public static <T> IdentifierGenerator<T> getIdentifierGenerator(String name) {
        if (name == null) {
            throw new RuntimeException("IdentifierGenerator name can't be null");
        }
        IdentifierGenerator<?> identifierGenerator = IDENTIFIER_GENERATOR_MAP.get(name);
        if (identifierGenerator == null) {
            throw new RuntimeException(name + " IdentifierGenerator is not exists");
        }
        return identifierGenerator;
    }

    public static void register(String name, IdentifierGenerator<?> identifierGenerator) {
        if (!"DEFAULT".equals(name) && IDENTIFIER_GENERATOR_MAP.containsKey(name)) {
            throw new RuntimeException(name + " IdentifierGenerator already exists");
        }
        IDENTIFIER_GENERATOR_MAP.put(name, identifierGenerator);
    }

    static {
        IdWorkerGenerator idWorkerGenerator = new IdWorkerGenerator();
        IDENTIFIER_GENERATOR_MAP.put("DEFAULT", idWorkerGenerator);
        IDENTIFIER_GENERATOR_MAP.put("UUID", new UUIDGenerator());
        IDENTIFIER_GENERATOR_MAP.put("mpNextId", idWorkerGenerator);
    }
}

