/*
 *  Copyright (c) 2024-2025, Ai东 (abc-127@live.cn) xbatis.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License").
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS,WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and limitations under the License.
 *
 */

package cn.xbatis.core.mybatis.mapper.context;

import db.sql.api.cmd.LikeMode;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

public class MybatisLikeQueryParameter extends MybatisQueryParameter {

    private final boolean notLike;

    private final LikeMode likeMode;

    public MybatisLikeQueryParameter(Object value, boolean isNotLike, LikeMode likeMode, Class<? extends TypeHandler<?>> typeHandler, JdbcType jdbcType) {
        super(value, typeHandler, jdbcType);
        this.notLike = isNotLike;
        this.likeMode = likeMode;
    }

    public boolean isNotLike() {
        return notLike;
    }

    public LikeMode getLikeMode() {
        return likeMode;
    }
}
