/*
 *  Copyright (c) 2024-2025, Ai东 (abc-127@live.cn) xbatis.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License").
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS,WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and limitations under the License.
 *
 */

package cn.xbatis.core.db.reflect;

import cn.xbatis.core.exception.NotTableClassException;
import cn.xbatis.db.annotations.ResultEntity;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ResultInfos {

    private static final Map<Class, ResultInfo> CACHE = new ConcurrentHashMap<>();

    /**
     * 获取结果映射类的的信息
     *
     * @param clazz
     * @return
     */

    public static ResultInfo get(Class clazz) {
        if (!clazz.isAnnotationPresent(ResultEntity.class)) {
            throw new NotTableClassException(clazz);
        }
        if (CACHE.containsKey(clazz)) {
            return CACHE.get(clazz);
        }
        synchronized (clazz) {
            if (CACHE.containsKey(clazz)) {
                return CACHE.get(clazz);
            }
            ResultInfo resultInfo = new ResultInfo(clazz);
            CACHE.put(clazz, resultInfo);
            return resultInfo;
        }
    }

}
