/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api;

import db.sql.api.KeywordWrap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public enum DbType {
    H2(new KeywordWrap("`", "`"), new HashSet<String>()),
    MYSQL(new KeywordWrap("`", "`"), new HashSet<String>()),
    MARIA_DB(new KeywordWrap("`", "`"), new HashSet<String>()),
    SQL_SERVER(new KeywordWrap("[", "]"), new HashSet<String>()),
    PGSQL(new KeywordWrap("\"", "\""), new HashSet<String>()),
    ORACLE(new KeywordWrap("\"", "\"", true), new HashSet<String>()),
    DM(new KeywordWrap("\"", "\"", true), new HashSet<String>()),
    DB2(new KeywordWrap("\"", "\"", true), new HashSet<String>()),
    KING_BASE(new KeywordWrap("\"", "\"", true), new HashSet<String>()),
    CLICK_HOUSE(new KeywordWrap("\"", "\"", true), new HashSet<String>()),
    SQLITE(new KeywordWrap("\"", "\""), new HashSet<String>()),
    OPEN_GAUSS(new KeywordWrap("\"", "\""), new HashSet<String>());

    private final KeywordWrap keywordWrap;
    private final Set<String> keywords;

    private DbType(KeywordWrap keywordWrap, Set<String> keywords) {
        this.keywordWrap = keywordWrap;
        this.keywords = keywords;
    }

    public static DbType getByName(String name) {
        DbType[] dbTypes;
        for (DbType dbType : dbTypes = DbType.values()) {
            if (!dbType.name().equals(name)) continue;
            return dbType;
        }
        return MYSQL;
    }

    public KeywordWrap getKeywordWrap() {
        return this.keywordWrap;
    }

    public Set<String> getKeywords() {
        return this.keywords;
    }

    public boolean addKeyword(String keyword) {
        return this.keywords.add(keyword);
    }

    public String wrap(String name) {
        if (this.getKeywords().contains(name)) {
            if (this.getKeywordWrap().isToUpperCase()) {
                name = name.toUpperCase(Locale.ENGLISH);
            }
            return this.getKeywordWrap().getPrefix() + name + this.getKeywordWrap().getSuffix();
        }
        return name;
    }
}

