/*
 * Decompiled with CFR 0.152.
 */
package cn.wzbos.android.rudolph;

import cn.wzbos.android.rudolph.RudolphBuildInfo;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0007J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcn/wzbos/android/rudolph/AndroidModuleUtil;", "", "()V", "currentDate", "", "getCurrentDate", "()Ljava/lang/String;", "createAndroidManifest", "", "info", "Lcn/wzbos/android/rudolph/RudolphBuildInfo;", "createApiModule", "moduleInfo", "createGradle", "rudolph-compiler"})
public final class AndroidModuleUtil {
    @NotNull
    public static final AndroidModuleUtil INSTANCE = new AndroidModuleUtil();

    private AndroidModuleUtil() {
    }

    @JvmStatic
    public static final void createApiModule(@NotNull RudolphBuildInfo moduleInfo) {
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        INSTANCE.createGradle(moduleInfo);
        INSTANCE.createAndroidManifest(moduleInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createAndroidManifest(RudolphBuildInfo info) {
        File manifestFile;
        if (info != null && info.exportApi() && !(manifestFile = new File(info.projectPath + '/' + info.exportProtocolName + "/src/main/AndroidManifest.xml")).exists()) {
            if (!manifestFile.getParentFile().exists()) {
                manifestFile.getParentFile().mkdirs();
            }
            OutputStreamWriter fileWriter = null;
            try {
                if (manifestFile.createNewFile()) {
                    fileWriter = new FileWriter(manifestFile);
                    fileWriter.write("<manifest package=\"" + info.exportProtocolPackage + "\" />");
                    fileWriter.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createGradle(RudolphBuildInfo info) {
        File gradleFile = new File(info.projectPath + '/' + info.exportProtocolName + "/build.gradle");
        if (!gradleFile.exists()) {
            if (!gradleFile.getParentFile().exists()) {
                gradleFile.getParentFile().mkdirs();
            }
            OutputStreamWriter fileWriter = null;
            try {
                if (gradleFile.createNewFile()) {
                    fileWriter = new FileWriter(gradleFile);
                    fileWriter.write("/**\n* " + info.exportProtocolName + "\n* Generated code from Rudolph.\n* date : " + this.getCurrentDate() + "\n*/\n\napply plugin: 'com.android.library'\n\nandroid {\n    compileSdkVersion " + info.getCompileSdkVersion() + "\n\n    defaultConfig {\n        minSdkVersion " + info.getMinSdkVersion() + "\n        targetSdkVersion " + info.getTargetSdkVersion() + "\n        versionName " + info.getVersionName() + "\n        versionCode " + info.getVersionCode() + "\n    }\n}\n\ndependencies {\n    implementation fileTree(dir: 'libs', include: ['*.jar'])\n    implementation \"cn.wzbos.android:rudolph:$rudolph_version\"\n}");
                    fileWriter.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private final String getCurrentDate() {
        Date date = new Date(System.currentTimeMillis());
        String string = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SimpleDateFormat(\"yyyy/M\u2026d HH:mm:ss\").format(date)");
        return string;
    }
}

