/*
 * Decompiled with CFR 0.152.
 */
package cn.wzbos.android.rudolph;

import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\r\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\bJ\u001b\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcn/wzbos/android/rudolph/Logger;", "", "msg", "Ljavax/annotation/processing/Messager;", "(Ljavax/annotation/processing/Messager;)V", "error", "", "", "", "formatStackTrace", "", "stackTrace", "", "Ljava/lang/StackTraceElement;", "([Ljava/lang/StackTraceElement;)Ljava/lang/String;", "info", "warning", "rudolph-compiler"})
public final class Logger {
    @NotNull
    private final Messager msg;

    public Logger(@NotNull Messager msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.msg = msg;
    }

    public final void info(@NotNull CharSequence info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (StringUtils.isNotEmpty((CharSequence)info)) {
            this.msg.printMessage(Diagnostic.Kind.NOTE, Intrinsics.stringPlus((String)"[Rudolph] ", (Object)info));
        }
    }

    public final void error(@NotNull CharSequence error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (StringUtils.isNotEmpty((CharSequence)error)) {
            this.msg.printMessage(Diagnostic.Kind.ERROR, Intrinsics.stringPlus((String)"[Rudolph] ", (Object)error));
        }
    }

    public final void error(@Nullable Throwable error) {
        if (error != null) {
            StringBuilder stringBuilder = new StringBuilder().append("[Rudolph] , [").append((Object)error.getMessage()).append(']');
            StackTraceElement[] stackTraceElementArray = error.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"error.stackTrace");
            this.msg.printMessage(Diagnostic.Kind.ERROR, StringsKt.trimIndent((String)stringBuilder.append(this.formatStackTrace(stackTraceElementArray)).append(' ').toString()));
        }
    }

    public final void warning(@NotNull CharSequence warning) {
        Intrinsics.checkNotNullParameter((Object)warning, (String)"warning");
        if (StringUtils.isNotEmpty((CharSequence)warning)) {
            this.msg.printMessage(Diagnostic.Kind.WARNING, Intrinsics.stringPlus((String)"[Rudolph] ", (Object)warning));
        }
    }

    private final String formatStackTrace(StackTraceElement[] stackTrace) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement element : stackTrace) {
            sb.append("    at ").append(element.toString());
            sb.append("\n");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }
}

