/*
 * Decompiled with CFR 0.152.
 */
package com.xsxx.sms.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class SmsUtil {
    public static final int SIGN_MAX_LENGTH = 25;
    public static final int CONTENT_MAX_LENGTH = 1000;
    public static final byte[] EMOJI_FIX = new byte[]{-30, -99, -92, 96};

    public static boolean isMobile(String phone) {
        return phone != null && phone.length() == 11 && phone.startsWith("1");
    }

    public static boolean isURL(String url) {
        return url != null && url.length() > 10 && (url.startsWith("http://") || url.startsWith("https://"));
    }

    public static String removePhonePrefix(String phone) {
        if (phone.startsWith("1")) {
            return phone;
        }
        if (phone.startsWith("86")) {
            return phone.substring(2);
        }
        if (phone.startsWith("+86")) {
            return phone.substring(3);
        }
        if (phone.startsWith("0086")) {
            return phone.substring(4);
        }
        return phone;
    }

    public static boolean hasEmojiFourChar(String content) {
        if (content == null) {
            return false;
        }
        byte[] conbyte = content.getBytes(Charset.forName("UTF8"));
        for (int i = 0; i < conbyte.length; ++i) {
            if ((conbyte[i] & 0xF8) != 240) continue;
            return true;
        }
        return false;
    }

    public static String removeEmojiFourChar(String content) {
        if (content == null) {
            return null;
        }
        byte[] conbyte = content.getBytes(Charset.forName("UTF8"));
        boolean hasEmoji = false;
        for (int i = 0; i < conbyte.length; ++i) {
            if ((conbyte[i] & 0xF8) != 240) continue;
            hasEmoji = true;
            for (int j = 0; j < 4; ++j) {
                if (i + j >= conbyte.length) continue;
                conbyte[i + j] = EMOJI_FIX[j];
            }
            i += 3;
        }
        if (hasEmoji) {
            try {
                return new String(conbyte, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return content;
    }

    public static int[] getSignPosition(String content) {
        if (content == null) {
            return null;
        }
        int lastIndex = content.length() - 1;
        int start = -1;
        int end = -1;
        if (content.startsWith("\u3010")) {
            end = content.indexOf("\u3011");
        } else if (content.startsWith("[")) {
            end = content.indexOf("]");
        }
        if (end > 1 && end < lastIndex && end <= 26) {
            return new int[]{0, end};
        }
        if (content.endsWith("\u3011")) {
            start = content.lastIndexOf("\u3010");
        } else if (content.endsWith("]")) {
            start = content.lastIndexOf("[");
        }
        if (start > 0 && start < lastIndex - 1 && lastIndex - start <= 26) {
            return new int[]{start, lastIndex};
        }
        return null;
    }

    public static String getSignName(String content) {
        int[] position = SmsUtil.getSignPosition(content);
        if (position == null) {
            return null;
        }
        return content.substring(position[0] + 1, position[1]);
    }

    public static String removeSign(String content) {
        int[] position = SmsUtil.getSignPosition(content);
        if (position == null) {
            return content;
        }
        if (position[0] == 0) {
            return content.substring(position[1] + 1);
        }
        return content.substring(0, position[0]);
    }
}

