/*
 * Decompiled with CFR 0.152.
 */
package com.xsxx.sms.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static final String PATTERN_DATE_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_DATE_MINUTE = "yyyy-MM-dd HH:mm";
    public static final String PATTERN_DATETIME = "yyyyMMddHHmmss";
    public static final String PATTERN_CMPP_DATETIME = "yyMMddHHmm";
    public static final String PATTERN_DATE = "yyyy-MM-dd";
    public static final String PATTERNDATE = "yyyyMMdd";
    public static final String PATTERN_MONTH = "yyyy-MM";
    public static final String PATTERN_TIME = "HH:mm:ss";

    public static String format(Date date, String pattern) {
        if (date == null) {
            throw new IllegalArgumentException("timestamp null illegal");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

    public static String format(Date date, SimpleDateFormat sdf) {
        if (date == null) {
            throw new IllegalArgumentException("timestamp null illegal");
        }
        return sdf.format(date);
    }

    public static String format(Date date) {
        return DateUtils.format(date, PATTERN_DATE_TIME);
    }

    public static String format(String pattern) {
        return DateUtils.format(new Date(), pattern);
    }

    public static Timestamp timestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Timestamp timestamp(Date date) {
        return new Timestamp(date.getTime());
    }

    public static Date parse(String dateStr, String pattern) {
        if (dateStr == null || dateStr.equals("")) {
            throw new RuntimeException("str date null");
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            return sdf.parse(dateStr);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date parse(String dateStr) {
        switch (dateStr.length()) {
            case 19: {
                return DateUtils.parse(dateStr, PATTERN_DATE_TIME);
            }
            case 16: {
                return DateUtils.parse(dateStr, PATTERN_DATE_MINUTE);
            }
            case 14: {
                return DateUtils.parse(dateStr, PATTERN_DATETIME);
            }
            case 10: {
                return DateUtils.parse(dateStr, PATTERN_DATE);
            }
            case 8: {
                return DateUtils.parse(dateStr, PATTERNDATE);
            }
            case 7: {
                return DateUtils.parse(dateStr, PATTERN_MONTH);
            }
        }
        throw new IllegalArgumentException("dateStr unpareseable");
    }

    public static Date addYears(Date date, int amount) {
        return DateUtils.add(date, 1, amount);
    }

    public static Date addMonths(Date date, int amount) {
        return DateUtils.add(date, 2, amount);
    }

    public static Date addWeeks(Date date, int amount) {
        return DateUtils.add(date, 3, amount);
    }

    public static Date addDays(Date date, int amount) {
        return DateUtils.add(date, 5, amount);
    }

    public static Date addHours(Date date, int amount) {
        return DateUtils.add(date, 11, amount);
    }

    public static Date addMinutes(Date date, int amount) {
        return DateUtils.add(date, 12, amount);
    }

    public static Date addSeconds(Date date, int amount) {
        return DateUtils.add(date, 13, amount);
    }

    public static Date addMilliseconds(Date date, int amount) {
        return DateUtils.add(date, 14, amount);
    }

    private static Date add(Date date, int calendarField, int amount) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    public static Date getFirstDayOfMonth(Calendar c) {
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        return c.getTime();
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return DateUtils.getFirstDayOfMonth(c);
    }

    public static Date getLastDayOfMonth(Calendar c) {
        int year = c.get(1);
        int month = c.get(2) + 1;
        if (month > 11) {
            month = 0;
            ++year;
        }
        c.set(year, month, 0, 23, 59, 59);
        return c.getTime();
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return DateUtils.getLastDayOfMonth(c);
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 != null && date2 != null) {
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(date1);
            Calendar cal2 = Calendar.getInstance();
            cal2.setTime(date2);
            return DateUtils.isSameDay(cal1, cal2);
        }
        throw new IllegalArgumentException("The date must not be null");
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 != null && cal2 != null) {
            return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
        }
        throw new IllegalArgumentException("The date must not be null");
    }

    public static boolean isSameDay(Date date) {
        Date now = new Date();
        return DateUtils.isSameDay(date, now);
    }

    public static boolean isSameDay(Calendar c) {
        Calendar d = Calendar.getInstance();
        return DateUtils.isSameDay(c, d);
    }

    public static Date getStartTimeOfDate(Calendar c) {
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getStartTimeOfDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return DateUtils.getStartTimeOfDate(c);
    }

    public static Date getEndTimeOfDate(Calendar c) {
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        return c.getTime();
    }

    public static Date getEndTimeOfDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return DateUtils.getEndTimeOfDate(c);
    }

    public static int toInt(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("toInt date null illegal");
        }
        return (int)(date.getTime() / 1000L);
    }

    public static int toInt() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public static Date int2Date(int time) {
        return new Date((long)time * 1000L);
    }

    public static int getDayStamp() {
        return DateUtils.getDayStamp(new Date());
    }

    public static int getDayStamp(Date date) {
        if (date == null) {
            date = new Date();
        }
        return Integer.valueOf(DateUtils.format(date, PATTERNDATE));
    }

    public static Date getTodayEndTime() {
        Calendar ca = Calendar.getInstance();
        ca.set(11, 23);
        ca.set(12, 59);
        ca.set(13, 59);
        ca.set(14, 0);
        return ca.getTime();
    }
}

