/*
 * Decompiled with CFR 0.152.
 */
package com.xsxx.sms;

import cn.hutool.json.JSONUtil;
import com.xsxx.sms.V2Client;
import com.xsxx.sms.model.BalanceResp;
import com.xsxx.sms.model.DailyStatsResp;
import com.xsxx.sms.model.Sms;
import com.xsxx.sms.security.Hmac;
import com.xsxx.sms.util.DateUtils;
import com.xsxx.sms.util.SmsUtil;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class V4Client
extends V2Client {
    @Deprecated
    private int maxSize;

    public V4Client(String url, String spId, String spKey, Integer requestPerHost, String fetchURL) throws IllegalArgumentException {
        super(url, spId, spKey, requestPerHost, fetchURL);
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        this.token = spKey;
        this.URI_SUBMIT = url + "sms/send/" + spId;
        this.URI_BATCHSUBMIT = url + "sms/sendBatch/" + spId;
        if (SmsUtil.isURL(fetchURL)) {
            if (!fetchURL.endsWith("/")) {
                fetchURL = fetchURL + "/";
            }
            this.URI_REPORT = fetchURL + "sms/getReport/" + spId;
            this.URI_DELIVRD = fetchURL + "sms/getUpstream/" + spId;
            this.URI_BALANCE = fetchURL + "sms/getBalance/" + spId;
            this.URI_DAILY_STATS = fetchURL + "sms/getDailyStats/" + spId;
        }
    }

    public V4Client(String url, String spId, String spKey, Integer requestPerHost) throws IllegalArgumentException {
        this(url, spId, spKey, requestPerHost, null);
    }

    public V4Client(String url, String spId, String spKey) throws IllegalArgumentException {
        this(url, spId, spKey, null, null);
    }

    @Override
    public BalanceResp getBalance() {
        if (this.URI_BALANCE == null) {
            return null;
        }
        Request request = this.makeRequest(this.URI_BALANCE, null);
        BalanceResp resp = new BalanceResp();
        try {
            Response response = this.okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                resp = (BalanceResp)JSONUtil.toBean((String)response.body().string(), BalanceResp.class);
            } else {
                resp.setStatus(response.code());
                resp.setMsg(response.message());
            }
        }
        catch (IOException e) {
            resp.setStatus(-1);
            resp.setMsg(e.getMessage());
        }
        return resp;
    }

    @Override
    public DailyStatsResp getDailyStats(String date) {
        if (date == null || this.URI_DAILY_STATS == null) {
            return null;
        }
        DailyStatsResp resp = new DailyStatsResp();
        try {
            Date checkDate = DateUtils.parse(date, "yyyyMMdd");
            if (checkDate == null) {
                resp.setStatus(-1);
                resp.setMsg("date pattern incorrect format (yyyyMMdd)");
                return resp;
            }
            Request request = this.makeRequest(this.URI_DAILY_STATS, "{\"date\":" + date + "}");
            Response response = this.okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                resp = (DailyStatsResp)JSONUtil.toBean((String)response.body().string(), DailyStatsResp.class);
            } else {
                resp.setStatus(response.code());
                resp.setMsg(response.message());
            }
        }
        catch (Exception e) {
            resp.setStatus(-1);
            resp.setMsg(e.getMessage());
        }
        return resp;
    }

    private Request makeRequest(String url, String body) {
        if (body == null) {
            body = "";
        }
        long timeStamp = System.currentTimeMillis();
        String signature = Hmac.createSignature(timeStamp, body, this.token);
        String header = "HMAC-SHA256 " + timeStamp + "," + signature;
        MediaType mediaType = MediaType.Companion.parse("application/json;charset=utf-8");
        RequestBody requestBody = RequestBody.Companion.create(body, mediaType);
        return new Request.Builder().url(url).addHeader("Authorization", header).post(requestBody).build();
    }

    @Override
    protected Request makeRequest(Sms sms) {
        String body = JSONUtil.toJsonStr((Object)sms);
        return this.makeRequest(this.URI_SUBMIT, body);
    }

    @Override
    @Deprecated
    protected Request makeRequest(List<Sms> smsContents) {
        String body = JSONUtil.toJsonStr(smsContents);
        return this.makeRequest(this.URI_BATCHSUBMIT, body);
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    protected Request makeRequest(String url) {
        String body = this.maxSize > 0 ? "{\"maxSize\":" + this.maxSize + "}" : "";
        return this.makeRequest(url, body);
    }
}

