/*
 * Decompiled with CFR 0.152.
 */
package cn.wusifx.zabbix;

import cn.wusifx.zabbix.Api;
import cn.wusifx.zabbix.Version;
import cn.wusifx.zabbix.request.BaseRequest;
import cn.wusifx.zabbix.request.RequestHandler;
import cn.wusifx.zabbix.request.builder.AuthRequestBuilder;
import cn.wusifx.zabbix.request.builder.UnAuthRequestBuilder;
import cn.wusifx.zabbix.request.builder.apiinfo.ApiinfoRequestBuilder;
import cn.wusifx.zabbix.response.ApiinfoResponse;
import cn.wusifx.zabbix.response.AuthResponse;
import cn.wusifx.zabbix.response.BaseResponse;
import cn.wusifx.zabbix.response.ResponseDecoder;
import cn.wusifx.zabbix.response.UnAuthResponse;
import feign.Feign;
import feign.Logger;
import feign.RequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.gson.GsonEncoder;
import feign.slf4j.Slf4jLogger;
import java.time.Instant;

public class Zabbix {
    private static Api api = null;
    private String url = "api_jsonrpc.php";
    private String auth;

    public void init(String host) {
        api = (Api)Feign.builder().logger((Logger)new Slf4jLogger()).logLevel(Logger.Level.FULL).requestInterceptor((RequestInterceptor)new RequestHandler()).decoder((Decoder)new ResponseDecoder()).encoder((Encoder)new GsonEncoder()).target(Api.class, host);
        ApiinfoResponse apiinfoResponse = (ApiinfoResponse)this.highLevelCall(new ApiinfoRequestBuilder().builder());
        System.out.printf("client version:%s->server version:%s", Version.info, apiinfoResponse.getVersion());
        System.out.println();
    }

    public void init(String host, String url) {
        this.url = url;
        this.init(host);
    }

    public String getAuth() {
        return this.auth;
    }

    public <T> BaseResponse<T> call(BaseRequest baseRequest) {
        return api.jsonrpc(baseRequest, this.url);
    }

    public <T extends BaseResponse> T highLevelCall(BaseRequest baseRequest) {
        return (T)api.jsonrpc(baseRequest, this.url);
    }

    public String auth(String userName, String password) {
        AuthResponse authResponse = (AuthResponse)this.highLevelCall(new AuthRequestBuilder(Instant.now().getEpochSecond()).setUserName(userName).setPassword(password).builder());
        this.auth = authResponse.getAuth();
        return authResponse.getAuth();
    }

    public Boolean unAuth(String auth) {
        UnAuthResponse unAuthResponse = (UnAuthResponse)this.highLevelCall(new UnAuthRequestBuilder(Instant.now().getEpochSecond(), auth).builder());
        return (Boolean)unAuthResponse.getResult();
    }

    public Boolean unAuth() {
        return this.unAuth(this.auth);
    }
}

