/*
 * Decompiled with CFR 0.152.
 */
package cn.wumoe.hime.module.http.server;

import cn.wumoe.hime.KotlinExtendKt;
import cn.wumoe.hime.api.scripting.HimeContext;
import cn.wumoe.hime.inter.Function;
import cn.wumoe.hime.inter.Module;
import cn.wumoe.hime.lexer.Num;
import cn.wumoe.hime.lexer.Token;
import cn.wumoe.hime.lexer.Word;
import cn.wumoe.hime.module.http.server.HimeHttpExchangeToken;
import cn.wumoe.hime.module.http.server.HimeHttpServerHandler;
import cn.wumoe.hime.module.http.server.HimeHttpServerToken;
import cn.wumoe.hime.module.http.server.HttpHandlerUtils;
import cn.wumoe.hime.semantic.Analysis;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.net.InetSocketAddress;
import java.util.Base64;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u000b\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0012"}, d2={"Lcn/wumoe/hime/module/http/server/HttpServerModule;", "Lcn/wumoe/hime/inter/Module;", "()V", "init", "", "context", "Lcn/wumoe/hime/api/scripting/HimeContext;", "HttpExchangeGetValue", "HttpExchangeIp", "HttpExchangePostValue", "HttpExchangeRequestMethod", "HttpExchangeReturnBase64", "HttpExchangeReturnString", "HttpServerCreate", "HttpServerCreateContext", "HttpServerRemoveContext", "HttpServerStart", "HttpServerStop", "hime"})
public final class HttpServerModule
extends Module {
    public HttpServerModule() {
        super("hime.http.server");
    }

    @Override
    public void init(@NotNull HimeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.addFunction(new HttpServerCreate());
        this.addFunction(new HttpServerStart());
        this.addFunction(new HttpServerCreateContext());
        this.addFunction(new HttpServerRemoveContext());
        this.addFunction(new HttpServerStop());
        this.addFunction(new HttpExchangeGetValue());
        this.addFunction(new HttpExchangePostValue());
        this.addFunction(new HttpExchangeReturnString());
        this.addFunction(new HttpExchangeReturnBase64());
        this.addFunction(new HttpExchangeIp());
        this.addFunction(new HttpExchangeRequestMethod());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/http/server/HttpServerModule$HttpServerCreateContext;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class HttpServerCreateContext
    extends Function {
        public HttpServerCreateContext() {
            super("http-server-context-create");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 3 && pars[0] instanceof HimeHttpServerToken) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.http.server.HimeHttpServerToken");
                HttpServer httpServer = ((HimeHttpServerToken)token).getHttpserver();
                String string = pars[1].toString();
                Analysis analysis = this.analysis;
                Intrinsics.checkNotNullExpressionValue((Object)analysis, (String)"analysis");
                String string2 = pars[1].toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pars[1].toString()");
                Function function = this.analysis.getFunction(pars[2].toString());
                Intrinsics.checkNotNullExpressionValue((Object)function, (String)"analysis.getFunction(pars[2].toString())");
                httpServer.createContext(string, new HimeHttpServerHandler(new HimeHttpServerHandler.HimeHttpServerHandlerFunction(analysis, string2, function)));
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/http/server/HttpServerModule$HttpServerRemoveContext;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class HttpServerRemoveContext
    extends Function {
        public HttpServerRemoveContext() {
            super("http-server-context-remove");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2 && pars[0] instanceof HimeHttpServerToken) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.http.server.HimeHttpServerToken");
                ((HimeHttpServerToken)token).getHttpserver().removeContext(pars[1].toString());
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/http/server/HttpServerModule$HttpServerCreate;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class HttpServerCreate
    extends Function {
        public HttpServerCreate() {
            super("http-server-create");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0) && pars[0] instanceof Num) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                HttpServer httpServer = HttpServer.create(new InetSocketAddress(((Num)token2).value.intValue()), 0);
                httpServer.setExecutor(Executors.newCachedThreadPool());
                Intrinsics.checkNotNullExpressionValue((Object)httpServer, (String)"httpServer");
                token = new HimeHttpServerToken(httpServer);
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/http/server/HttpServerModule$HttpServerStop;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class HttpServerStop
    extends Function {
        public HttpServerStop() {
            super("http-server-stop");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2 && pars[0] instanceof HimeHttpServerToken && pars[1] instanceof Num) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.http.server.HimeHttpServerToken");
                HttpServer httpServer = ((HimeHttpServerToken)token).getHttpserver();
                Token token2 = pars[1];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                httpServer.stop(((Num)token2).value.intValue());
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/http/server/HttpServerModule$HttpServerStart;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class HttpServerStart
    extends Function {
        public HttpServerStart() {
            super("http-server-start");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0) && pars[0] instanceof HimeHttpServerToken) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.http.server.HimeHttpServerToken");
                ((HimeHttpServerToken)token).getHttpserver().start();
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/http/server/HttpServerModule$HttpExchangeGetValue;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class HttpExchangeGetValue
    extends Function {
        public HttpExchangeGetValue() {
            super("http-server-get-value");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2 && pars[0] instanceof HimeHttpExchangeToken) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.http.server.HimeHttpExchangeToken");
                HimeHttpExchangeToken exchange = (HimeHttpExchangeToken)token2;
                String string = exchange.getGetValue().get(pars[1].toString());
                Intrinsics.checkNotNull((Object)string);
                token = KotlinExtendKt.toWord(string);
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/http/server/HttpServerModule$HttpExchangeIp;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class HttpExchangeIp
    extends Function {
        public HttpExchangeIp() {
            super("http-server-ip");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0) && pars[0] instanceof HimeHttpExchangeToken) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.http.server.HimeHttpExchangeToken");
                HimeHttpExchangeToken exchange = (HimeHttpExchangeToken)token2;
                String string = exchange.getExchange().getRemoteAddress().getAddress().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"exchange.exchange.remoteAddress.address.toString()");
                token = KotlinExtendKt.toWord(string);
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/http/server/HttpServerModule$HttpExchangeRequestMethod;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class HttpExchangeRequestMethod
    extends Function {
        public HttpExchangeRequestMethod() {
            super("http-server-request-method");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0) && pars[0] instanceof HimeHttpExchangeToken) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.http.server.HimeHttpExchangeToken");
                HimeHttpExchangeToken exchange = (HimeHttpExchangeToken)token2;
                String string = exchange.getExchange().getRequestMethod();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"exchange.exchange.requestMethod");
                token = KotlinExtendKt.toWord(string);
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/http/server/HttpServerModule$HttpExchangeReturnString;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class HttpExchangeReturnString
    extends Function {
        public HttpExchangeReturnString() {
            super("http-server-return-string");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 3 && pars[0] instanceof HimeHttpExchangeToken && pars[1] instanceof Num) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.http.server.HimeHttpExchangeToken");
                HimeHttpExchangeToken exchange = (HimeHttpExchangeToken)token2;
                HttpExchange httpExchange = exchange.getExchange();
                Token token3 = pars[1];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                int n = ((Num)token3).value.intValue();
                String string = pars[2].toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pars[2].toString()");
                HttpHandlerUtils.INSTANCE.result(httpExchange, n, string);
                token = pars[2];
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/http/server/HttpServerModule$HttpExchangeReturnBase64;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class HttpExchangeReturnBase64
    extends Function {
        public HttpExchangeReturnBase64() {
            super("http-server-return-base64");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 3 && pars[0] instanceof HimeHttpExchangeToken && pars[1] instanceof Num) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.http.server.HimeHttpExchangeToken");
                HimeHttpExchangeToken exchange = (HimeHttpExchangeToken)token2;
                HttpExchange httpExchange = exchange.getExchange();
                Token token3 = pars[1];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                int n = ((Num)token3).value.intValue();
                byte[] byArray = Base64.getDecoder().decode(pars[2].toString());
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getDecoder().decode(pars[2].toString())");
                HttpHandlerUtils.INSTANCE.result(httpExchange, n, byArray);
                token = pars[2];
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/http/server/HttpServerModule$HttpExchangePostValue;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class HttpExchangePostValue
    extends Function {
        public HttpExchangePostValue() {
            super("http-server-post-value");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2 && pars[0] instanceof HimeHttpExchangeToken) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.http.server.HimeHttpExchangeToken");
                HimeHttpExchangeToken exchange = (HimeHttpExchangeToken)token2;
                String string = exchange.getPostValue().get(pars[1].toString());
                Intrinsics.checkNotNull((Object)string);
                token = KotlinExtendKt.toWord(string);
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }
}

