/*
 * Decompiled with CFR 0.152.
 */
package cn.wumoe.hime.module;

import cn.wumoe.hime.KotlinExtendKt;
import cn.wumoe.hime.api.scripting.HimeContext;
import cn.wumoe.hime.inter.Function;
import cn.wumoe.hime.inter.Module;
import cn.wumoe.hime.lexer.Num;
import cn.wumoe.hime.lexer.Real;
import cn.wumoe.hime.lexer.Token;
import cn.wumoe.hime.lexer.Word;
import com.google.common.math.BigIntegerMath;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\u0018\u00002\u00020\u0001:\u001a\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006!"}, d2={"Lcn/wumoe/hime/module/MathModule;", "Lcn/wumoe/hime/inter/Module;", "()V", "init", "", "context", "Lcn/wumoe/hime/api/scripting/HimeContext;", "Abs", "Acos", "Acosh", "Asin", "Asinh", "Atan", "Atan2", "Atanh", "Average", "Ceil", "Cos", "Cosh", "Floor", "Gcd", "Lcm", "Log10", "Log2", "Max", "Min", "Mod", "Pow", "Sin", "Sinh", "Sqrt", "Tan", "Tanh", "hime"})
public final class MathModule
extends Module {
    public MathModule() {
        super("hime.math");
    }

    @Override
    public void init(@NotNull HimeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.addFunction(new Max());
        this.addFunction(new Min());
        this.addFunction(new Sqrt());
        this.addFunction(new Log10());
        this.addFunction(new Log2());
        this.addFunction(new Abs());
        this.addFunction(new Gcd());
        this.addFunction(new Lcm());
        this.addFunction(new Mod());
        this.addFunction(new Pow());
        this.addFunction(new Average());
        this.addFunction(new Ceil());
        this.addFunction(new Floor());
        this.addFunction(new Sin());
        this.addFunction(new Cos());
        this.addFunction(new Asin());
        this.addFunction(new Acos());
        this.addFunction(new Asinh());
        this.addFunction(new Acosh());
        this.addFunction(new Tanh());
        this.addFunction(new Atanh());
        this.addFunction(new Atan2());
        this.addFunction(new Atan());
        this.addFunction(new Tan());
        this.addFunction(new Sinh());
        this.addFunction(new Cosh());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Ceil;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Ceil
    extends Function {
        public Ceil() {
            super("ceil");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                token = KotlinExtendKt.toNum(new BigInteger(new BigDecimal(pars[0].toString()).setScale(0, RoundingMode.CEILING).toPlainString()));
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Sin;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Sin
    extends Function {
        public Sin() {
            super("sin");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                token = KotlinExtendKt.toReal(Math.sin(new BigDecimal(pars[0].toString()).doubleValue()));
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Cos;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Cos
    extends Function {
        public Cos() {
            super("cos");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                token = KotlinExtendKt.toReal(Math.cos(new BigDecimal(pars[0].toString()).doubleValue()));
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Asin;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Asin
    extends Function {
        public Asin() {
            super("asin");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                token = KotlinExtendKt.toReal(Math.asin(new BigDecimal(pars[0].toString()).doubleValue()));
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Acos;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Acos
    extends Function {
        public Acos() {
            super("acos");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                token = KotlinExtendKt.toReal(Math.acos(new BigDecimal(pars[0].toString()).doubleValue()));
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Asinh;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Asinh
    extends Function {
        public Asinh() {
            super("asinh");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                token = KotlinExtendKt.toReal(MathKt.asinh((double)new BigDecimal(pars[0].toString()).doubleValue()));
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Acosh;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Acosh
    extends Function {
        public Acosh() {
            super("acosh");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                token = KotlinExtendKt.toReal(MathKt.acosh((double)new BigDecimal(pars[0].toString()).doubleValue()));
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Tanh;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Tanh
    extends Function {
        public Tanh() {
            super("tanh");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                token = KotlinExtendKt.toReal(Math.tanh(new BigDecimal(pars[0].toString()).doubleValue()));
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Atanh;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Atanh
    extends Function {
        public Atanh() {
            super("atanh");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                token = KotlinExtendKt.toReal(MathKt.atanh((double)new BigDecimal(pars[0].toString()).doubleValue()));
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Atan;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Atan
    extends Function {
        public Atan() {
            super("atan");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                token = KotlinExtendKt.toReal(Math.atan(new BigDecimal(pars[0].toString()).doubleValue()));
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Atan2;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Atan2
    extends Function {
        public Atan2() {
            super("atan2");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2) {
                token = KotlinExtendKt.toReal(Math.atan2(new BigDecimal(pars[0].toString()).doubleValue(), new BigDecimal(pars[1].toString()).doubleValue()));
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Tan;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Tan
    extends Function {
        public Tan() {
            super("tan");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                token = KotlinExtendKt.toReal(Math.tan(new BigDecimal(pars[0].toString()).doubleValue()));
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Sinh;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Sinh
    extends Function {
        public Sinh() {
            super("sinh");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                token = KotlinExtendKt.toReal(Math.sinh(new BigDecimal(pars[0].toString()).doubleValue()));
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Cosh;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Cosh
    extends Function {
        public Cosh() {
            super("cosh");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                token = KotlinExtendKt.toReal(Math.cosh(new BigDecimal(pars[0].toString()).doubleValue()));
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Floor;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Floor
    extends Function {
        public Floor() {
            super("floor");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                token = KotlinExtendKt.toNum(new BigInteger(new BigDecimal(pars[0].toString()).setScale(0, RoundingMode.FLOOR).toPlainString()));
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Average;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Average
    extends Function {
        public Average() {
            super("average");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                BigDecimal num = BigDecimal.ZERO;
                int n = pars.length;
                for (int i = 0; i < n; ++i) {
                    BigDecimal bigDecimal;
                    Token t = pars[i];
                    if (t instanceof Num) {
                        bigDecimal = new BigDecimal(((Num)t).value.toString());
                    } else {
                        Intrinsics.checkNotNull((Object)t, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Real");
                        bigDecimal = ((Real)t).value;
                    }
                    num = num.add(bigDecimal);
                }
                BigDecimal bigDecimal = BigDecimal.valueOf(pars.length);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this.toLong())");
                BigDecimal bigDecimal2 = num.divide(bigDecimal);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"num.divide(pars.size.toBigDecimal())");
                token = KotlinExtendKt.toReal(bigDecimal2);
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Pow;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Pow
    extends Function {
        public Pow() {
            super("pow");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2) {
                Token token2;
                if (pars[0] instanceof Num) {
                    Token token3 = pars[0];
                    Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    BigInteger bigInteger = ((Num)token3).value;
                    Token token4 = pars[1];
                    Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    BigInteger bigInteger2 = bigInteger.pow(((Num)token4).value.intValue());
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"pars[0] as Num).value.po\u20261] as Num).value.toInt())");
                    token2 = KotlinExtendKt.toNum(bigInteger2);
                } else if (pars[0] instanceof Real) {
                    Token token5 = pars[0];
                    Intrinsics.checkNotNull((Object)token5, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Real");
                    BigDecimal bigDecimal = ((Real)token5).value;
                    Token token6 = pars[1];
                    Intrinsics.checkNotNull((Object)token6, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    BigDecimal bigDecimal2 = bigDecimal.pow(((Num)token6).value.intValue());
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"pars[0] as Real).value.p\u20261] as Num).value.toInt())");
                    token2 = KotlinExtendKt.toReal(bigDecimal2);
                } else {
                    token2 = Word.NIL;
                }
                Token token7 = token2;
                Intrinsics.checkNotNullExpressionValue((Object)token7, (String)"{\n                if (pa\u2026   Word.NIL\n            }");
                token = token7;
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Mod;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Mod
    extends Function {
        public Mod() {
            super("mod");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2 && pars[0] instanceof Num && pars[1] instanceof Num) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                BigInteger bigInteger = ((Num)token2).value;
                Token token3 = pars[1];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                BigInteger bigInteger2 = bigInteger.mod(((Num)token3).value);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"pars[0] as Num).value.mod((pars[1] as Num).value)");
                token = KotlinExtendKt.toNum(bigInteger2);
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Max;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Max
    extends Function {
        public Max() {
            super("max");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            int index = 0;
            if (!(pars.length == 0)) {
                BigDecimal bigDecimal;
                if (pars[0] instanceof Num) {
                    Token token = pars[0];
                    Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    bigDecimal = new BigDecimal(((Num)token).value);
                } else if (pars[0] instanceof Real) {
                    Token token = pars[0];
                    Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Real");
                    bigDecimal = ((Real)token).value;
                } else {
                    Word word = Word.NIL;
                    Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                    return word;
                }
                BigDecimal max = bigDecimal;
                int n = pars.length;
                for (int i = 1; i < n; ++i) {
                    BigDecimal bigDecimal2;
                    if (pars[i] instanceof Num) {
                        Token token = pars[i];
                        Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                        bigDecimal2 = new BigDecimal(((Num)token).value);
                    } else if (pars[i] instanceof Real) {
                        Token token = pars[i];
                        Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Real");
                        bigDecimal2 = ((Real)token).value;
                    } else {
                        Word word = Word.NIL;
                        Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                        return word;
                    }
                    BigDecimal temp = bigDecimal2;
                    if (temp.compareTo(max) <= 0) continue;
                    max = temp;
                    index = i;
                }
            }
            return pars[index];
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Min;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Min
    extends Function {
        public Min() {
            super("min");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            int index = 0;
            if (!(pars.length == 0)) {
                BigDecimal bigDecimal;
                if (pars[0] instanceof Num) {
                    Token token = pars[0];
                    Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    bigDecimal = new BigDecimal(((Num)token).value);
                } else if (pars[0] instanceof Real) {
                    Token token = pars[0];
                    Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Real");
                    bigDecimal = ((Real)token).value;
                } else {
                    Word word = Word.NIL;
                    Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                    return word;
                }
                BigDecimal min = bigDecimal;
                int n = pars.length;
                for (int i = 1; i < n; ++i) {
                    BigDecimal bigDecimal2;
                    if (pars[i] instanceof Num) {
                        Token token = pars[i];
                        Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                        bigDecimal2 = new BigDecimal(((Num)token).value);
                    } else if (pars[i] instanceof Real) {
                        Token token = pars[i];
                        Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Real");
                        bigDecimal2 = ((Real)token).value;
                    } else {
                        Word word = Word.NIL;
                        Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                        return word;
                    }
                    BigDecimal temp = bigDecimal2;
                    if (temp.compareTo(min) >= 0) continue;
                    min = temp;
                    index = i;
                }
            }
            return pars[index];
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Sqrt;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Sqrt
    extends Function {
        public Sqrt() {
            super("sqrt");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                Token token2;
                if (pars[0] instanceof Num) {
                    Token token3 = pars[0];
                    Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    BigInteger bigInteger = ((Num)token3).value.sqrt();
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"pars[0] as Num).value.sqrt()");
                    token2 = KotlinExtendKt.toNum(bigInteger);
                } else if (pars[0] instanceof Real) {
                    Token token4 = pars[0];
                    Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Real");
                    BigDecimal bigDecimal = ((Real)token4).value.sqrt(new MathContext(10));
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"pars[0] as Real).value.sqrt(MathContext(10))");
                    token2 = KotlinExtendKt.toReal(bigDecimal);
                } else {
                    token2 = Word.NIL;
                }
                Token token5 = token2;
                Intrinsics.checkNotNullExpressionValue((Object)token5, (String)"{\n                if (pa\u2026   Word.NIL\n            }");
                token = token5;
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Abs;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Abs
    extends Function {
        public Abs() {
            super("abs");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                Token token2;
                if (pars[0] instanceof Num) {
                    Token token3 = pars[0];
                    Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    BigInteger bigInteger = ((Num)token3).value.abs();
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"pars[0] as Num).value.abs()");
                    token2 = KotlinExtendKt.toNum(bigInteger);
                } else if (pars[0] instanceof Real) {
                    Token token4 = pars[0];
                    Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Real");
                    BigDecimal bigDecimal = ((Real)token4).value.abs();
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"pars[0] as Real).value.abs()");
                    token2 = KotlinExtendKt.toReal(bigDecimal);
                } else {
                    token2 = Word.NIL;
                }
                Token token5 = token2;
                Intrinsics.checkNotNullExpressionValue((Object)token5, (String)"{\n                if (pa\u2026   Word.NIL\n            }");
                token = token5;
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Gcd;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Gcd
    extends Function {
        public Gcd() {
            super("gcd");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2 && pars[0] instanceof Num && pars[1] instanceof Num) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                BigInteger bigInteger = ((Num)token2).value;
                Token token3 = pars[1];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                BigInteger temp = bigInteger.gcd(((Num)token3).value);
                int n = pars.length;
                for (int i = 2; i < n; ++i) {
                    if (!(pars[i] instanceof Num)) {
                        Word word = Word.NIL;
                        Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                        return word;
                    }
                    Token token4 = pars[i];
                    Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    temp = temp.gcd(((Num)token4).value);
                }
                BigInteger bigInteger2 = temp;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"temp");
                token = KotlinExtendKt.toNum(bigInteger2);
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\b\u001a\u00020\t*\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"Lcn/wumoe/hime/module/MathModule$Lcm;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "lcm", "Ljava/math/BigInteger;", "n", "hime"})
    public static final class Lcm
    extends Function {
        public Lcm() {
            super("lcm");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2 && pars[0] instanceof Num && pars[1] instanceof Num) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                BigInteger bigInteger = ((Num)token2).value;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"pars[0] as Num).value");
                Token token3 = pars[1];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                BigInteger bigInteger2 = ((Num)token3).value;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"pars[1] as Num).value");
                BigInteger temp = this.lcm(bigInteger, bigInteger2);
                int n = pars.length;
                for (int i = 2; i < n; ++i) {
                    if (!(pars[i] instanceof Num)) {
                        Word word = Word.NIL;
                        Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                        return word;
                    }
                    Token token4 = pars[i];
                    Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    BigInteger bigInteger3 = ((Num)token4).value;
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"pars[i] as Num).value");
                    temp = this.lcm(temp, bigInteger3);
                }
                token = KotlinExtendKt.toNum(temp);
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }

        private final BigInteger lcm(BigInteger $this$lcm, BigInteger n) {
            BigInteger bigInteger = $this$lcm.multiply(n).abs().divide($this$lcm.gcd(n));
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.multiply(n).abs()).divide(this.gcd(n))");
            return bigInteger;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Log10;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Log10
    extends Function {
        public Log10() {
            super("log10");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0) && pars[0] instanceof Num) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                Num num = Num.toNum(BigIntegerMath.log10((BigInteger)((Num)token2).value, (RoundingMode)RoundingMode.CEILING));
                Intrinsics.checkNotNullExpressionValue((Object)num, (String)"{\n                Num.to\u2026e.CEILING))\n            }");
                token = num;
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/MathModule$Log2;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Log2
    extends Function {
        public Log2() {
            super("log2");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0) && pars[0] instanceof Num) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                Num num = Num.toNum(BigIntegerMath.log2((BigInteger)((Num)token2).value, (RoundingMode)RoundingMode.CEILING));
                Intrinsics.checkNotNullExpressionValue((Object)num, (String)"{\n                Num.to\u2026e.CEILING))\n            }");
                token = num;
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }
}

