/*
 * Decompiled with CFR 0.152.
 */
package cn.wumoe.hime.module;

import cn.wumoe.hime.KotlinExtendKt;
import cn.wumoe.hime.api.scripting.HimeContext;
import cn.wumoe.hime.inter.Function;
import cn.wumoe.hime.inter.Module;
import cn.wumoe.hime.lexer.Array;
import cn.wumoe.hime.lexer.Num;
import cn.wumoe.hime.lexer.Real;
import cn.wumoe.hime.lexer.Token;
import cn.wumoe.hime.lexer.Word;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004\u0007\b\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcn/wumoe/hime/module/ListModule;", "Lcn/wumoe/hime/inter/Module;", "()V", "init", "", "context", "Lcn/wumoe/hime/api/scripting/HimeContext;", "Filter", "Map", "Reverse", "Sort", "hime"})
public final class ListModule
extends Module {
    public ListModule() {
        super("hime.list");
    }

    @Override
    public void init(@NotNull HimeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.addFunction(new Reverse());
        this.addFunction(new Map());
        this.addFunction(new Filter());
        this.addFunction(new Sort());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J5\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0010J-\u0010\u0011\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcn/wumoe/hime/module/ListModule$Sort;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "merge", "", "a", "Ljava/math/BigDecimal;", "low", "", "mid", "high", "([Ljava/math/BigDecimal;III)V", "mergeSort", "([Ljava/math/BigDecimal;II)V", "hime"})
    public static final class Sort
    extends Function {
        public Sort() {
            super("sort");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0) && pars[0] instanceof Array) {
                void var2_2;
                int i;
                Array result = new Array(new ArrayList());
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                List<Token> tokens = ((Array)token2).tokens;
                BigDecimal[] array = new BigDecimal[tokens.size()];
                int n = tokens.size();
                for (i = 0; i < n; ++i) {
                    if (tokens.get(i) instanceof Num) {
                        Token token3 = tokens.get(i);
                        Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                        array[i] = new BigDecimal(((Num)token3).value);
                        continue;
                    }
                    if (tokens.get(i) instanceof Real) {
                        Token token4 = tokens.get(i);
                        Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Real");
                        array[i] = ((Real)token4).value;
                        continue;
                    }
                    Word word = Word.NIL;
                    Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                    return word;
                }
                this.mergeSort(array, 0, array.length - 1);
                n = array.length;
                for (i = 0; i < n; ++i) {
                    BigDecimal bigDecimal = array[i];
                    String s = String.valueOf(bigDecimal != null ? KotlinExtendKt.simplification(bigDecimal) : null);
                    if (StringsKt.contains$default((CharSequence)s, (CharSequence)".", (boolean)false, (int)2, null)) {
                        tokens.set(i, new Real(array[i]));
                        continue;
                    }
                    tokens.set(i, new Num(new BigInteger(s)));
                }
                for (i = tokens.size() - 1; -1 < i; --i) {
                    result.tokens.add(tokens.get(i));
                }
                token = (Token)var2_2;
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }

        private final void merge(BigDecimal[] a, int low, int mid, int high) {
            BigDecimal[] temp = new BigDecimal[high - low + 1];
            int i = low;
            int j = mid + 1;
            int k = 0;
            while (i <= mid && j <= high) {
                int n = k++;
                BigDecimal bigDecimal = a[i];
                Intrinsics.checkNotNull((Object)bigDecimal);
                temp[n] = bigDecimal.compareTo(a[j]) > 0 ? a[i++] : a[j++];
            }
            while (i <= mid) {
                temp[k++] = a[i++];
            }
            while (j <= high) {
                temp[k++] = a[j++];
            }
            for (BigDecimal bigDecimal : temp) {
                Intrinsics.checkNotNull((Object)bigDecimal);
                a[k2 + low] = bigDecimal;
            }
        }

        private final void mergeSort(BigDecimal[] a, int low, int high) {
            int mid = (low + high) / 2;
            if (low < high) {
                this.mergeSort(a, low, mid);
                this.mergeSort(a, mid + 1, high);
                this.merge(a, low, mid, high);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/ListModule$Reverse;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Reverse
    extends Function {
        public Reverse() {
            super("reverse");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0) && pars[0] instanceof Array) {
                void var2_2;
                Array result = new Array(new ArrayList());
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                List<Token> tokens = ((Array)token2).tokens;
                for (int i = tokens.size() - 1; -1 < i; --i) {
                    result.tokens.add(tokens.get(i));
                }
                token = (Token)var2_2;
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/ListModule$Map;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Map
    extends Function {
        public Map() {
            super("map");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2 && pars[1] instanceof Array) {
                void var2_2;
                Array result = new Array(new ArrayList());
                Token token2 = pars[1];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                List<Token> tokens = ((Array)token2).tokens;
                int n = tokens.size();
                for (int i = 0; i < n; ++i) {
                    Function func = this.analysis.getFunction(pars[0].toString());
                    func.analysis = this.analysis;
                    Token[] array = new Token[pars.length - 1];
                    array[0] = tokens.get(i);
                    int n2 = pars.length - 1;
                    for (int j = 1; j < n2; ++j) {
                        Token token3 = pars[j + 1];
                        Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                        array[j] = ((Array)token3).tokens.get(i);
                    }
                    result.add(func.call(array));
                }
                token = (Token)var2_2;
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/ListModule$Filter;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Filter
    extends Function {
        public Filter() {
            super("filter");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2 && pars[1] instanceof Array) {
                void var2_2;
                Array result = new Array(new ArrayList());
                Token token2 = pars[1];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                List<Token> tokens = ((Array)token2).tokens;
                for (Token t : tokens) {
                    Function func = this.analysis.getFunction(pars[0].toString());
                    func.analysis = this.analysis;
                    Token[] tokenArray = new Token[]{t};
                    if (!Intrinsics.areEqual((Object)func.call(tokenArray), (Object)Word.True)) continue;
                    result.add(t);
                }
                token = (Token)var2_2;
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }
}

