/*
 * Decompiled with CFR 0.152.
 */
package cn.wumoe.hime.module;

import cn.wumoe.hime.KotlinExtendKt;
import cn.wumoe.hime.api.scripting.HimeContext;
import cn.wumoe.hime.inter.Function;
import cn.wumoe.hime.inter.Module;
import cn.wumoe.hime.lexer.Num;
import cn.wumoe.hime.lexer.Token;
import cn.wumoe.hime.lexer.Word;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcn/wumoe/hime/module/BarcodeModule;", "Lcn/wumoe/hime/inter/Module;", "()V", "init", "", "context", "Lcn/wumoe/hime/api/scripting/HimeContext;", "BarcodeCodeDecode", "BarcodeCodeEncode", "hime"})
public final class BarcodeModule
extends Module {
    public BarcodeModule() {
        super("hime.barcode");
    }

    @Override
    public void init(@NotNull HimeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.addFunction(new BarcodeCodeEncode());
        this.addFunction(new BarcodeCodeDecode());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/BarcodeModule$BarcodeCodeDecode;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class BarcodeCodeDecode
    extends Function {
        public BarcodeCodeDecode() {
            super("barcode-decode");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                BufferedImage image = ImageIO.read(new ByteArrayInputStream(Base64.getDecoder().decode(pars[0].toString())));
                LuminanceSource source = (LuminanceSource)new BufferedImageLuminanceSource(image);
                BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer(source));
                Result result = new MultiFormatReader().decode(bitmap, null);
                String string = result.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.text");
                token = KotlinExtendKt.toWord(string);
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcn/wumoe/hime/module/BarcodeModule$BarcodeCodeEncode;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "checkStandardUPCEANChecksum", "", "s", "", "hime"})
    public static final class BarcodeCodeEncode
    extends Function {
        public BarcodeCodeEncode() {
            super("barcode-encode");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 3 && pars[0] instanceof Num && pars[1] instanceof Num) {
                Word word;
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                int width = ((Num)token2).value.intValue();
                Token token3 = pars[1];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                int height = ((Num)token3).value.intValue();
                String string = pars[2].toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pars[2].toString()");
                String value = string;
                if (this.checkStandardUPCEANChecksum(value)) {
                    BitMatrix bitMatrix = new MultiFormatWriter().encode(pars[2].toString(), BarcodeFormat.EAN_13, width, height, null);
                    BufferedImage image = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)image, "png", byteArrayOutputStream);
                    String string2 = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getEncoder().encodeToStr\u2026tputStream.toByteArray())");
                    word = KotlinExtendKt.toWord(string2);
                } else {
                    word = Word.NIL;
                }
                Word word2 = word;
                Intrinsics.checkNotNullExpressionValue((Object)word2, (String)"{\n                val wi\u2026   Word.NIL\n            }");
                token = word2;
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }

        private final boolean checkStandardUPCEANChecksum(CharSequence s) {
            int length = s.length();
            if (length == 0) {
                return false;
            }
            int sum = 0;
            BarcodeCodeEncode $this$checkStandardUPCEANChecksum_u24lambda_u2d0 = this;
            boolean bl = false;
            for (int i = length - 2; i >= 0; i -= 2) {
                int digit = s.charAt(i) - 48;
                if (digit < 0 || digit > 9) {
                    return false;
                }
                sum += digit;
            }
            sum *= 3;
            for (int i = length - 1; i >= 0; i -= 2) {
                int digit = s.charAt(i) - 48;
                if (digit < 0 || digit > 9) {
                    return false;
                }
                sum += digit;
            }
            return sum % 10 == 0;
        }
    }
}

