/*
 * Decompiled with CFR 0.152.
 */
package cn.wumoe.hime.inter;

import cn.wumoe.hime.lexer.Tag;
import cn.wumoe.hime.lexer.Token;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;

public class ASTNode
extends Token {
    public static final ASTNode EMPTY = new ASTNode(new Token(' '));
    public Token tok;
    public AstTag tag = AstTag.BASIC;
    public final List<ASTNode> prev;

    public ASTNode(Token tok) {
        super(Tag.AST);
        this.tok = tok;
        this.prev = new LinkedList<ASTNode>();
    }

    public ASTNode(Token tok, List<ASTNode> prev) {
        super(Tag.AST);
        this.tok = tok;
        this.prev = prev;
    }

    public ASTNode copy() {
        LinkedList<ASTNode> list = new LinkedList<ASTNode>();
        for (ASTNode ast : this.prev) {
            list.add(ast.copy());
        }
        ASTNode newAst = new ASTNode(this.tok, list);
        newAst.tag = this.tag;
        return newAst;
    }

    public void add(ASTNode node) {
        this.prev.add(node);
    }

    public ASTNode get(int i) {
        return this.prev.get(i);
    }

    public void remove(ASTNode node) {
        this.prev.remove(node);
    }

    public void remove(int index) {
        this.prev.remove(index);
    }

    public void clear() {
        this.prev.clear();
    }

    public int size() {
        return this.prev.size();
    }

    public ListIterator<ASTNode> listIterator() {
        return this.prev.listIterator();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ASTNode astNode = (ASTNode)o;
        return this.tok.equals(astNode.tok) && this.prev.equals(astNode.prev);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tok, this.prev);
    }

    @Override
    public String toString() {
        return this.tok.toString();
    }

    public static enum AstTag {
        FUNCTION,
        BASIC;

    }
}

