/*
 * Decompiled with CFR 0.152.
 */
package cn.wumoe.hime.parser;

import cn.wumoe.hime.exceptions.HimeParserException;
import cn.wumoe.hime.inter.ASTNode;
import cn.wumoe.hime.lexer.Lexer;
import cn.wumoe.hime.lexer.Tag;
import cn.wumoe.hime.lexer.Token;
import cn.wumoe.hime.lexer.Word;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class Parser {
    private final List<Token> lexTokens = new LinkedList<Token>();
    private int index = 0;
    private Token look;

    public Parser(Lexer lex) {
        while (lex.state) {
            this.lexTokens.add(lex.scan());
        }
        this.move();
    }

    void move() {
        this.look = this.lexTokens.get(this.index++);
    }

    void error(String s) throws HimeParserException {
        throw new HimeParserException(s);
    }

    public List<ASTNode> program() throws HimeParserException {
        ArrayList<ASTNode> asts = new ArrayList<ASTNode>();
        ArrayDeque<ASTNode> astStack = new ArrayDeque<ASTNode>();
        int state = -1;
        while (this.index < this.lexTokens.size()) {
            ASTNode temp;
            if (state == 1) {
                if (this.look == Word.RB) {
                    temp = ASTNode.EMPTY;
                    assert (astStack.peek() != null);
                    ((ASTNode)astStack.peek()).add(temp);
                    state = -1;
                    this.move();
                    continue;
                }
                if (this.look instanceof Word || this.look.tag == Tag.DA) {
                    if (this.look == Word.LB) {
                        --this.index;
                        this.lexTokens.add(this.index, Word.SP);
                        this.lexTokens.add(this.index, Word.STRUCTURE);
                        this.move();
                    }
                    temp = new ASTNode(this.look);
                    astStack.push(temp);
                    asts.add(temp);
                    state = -1;
                } else {
                    this.error("nonstandard word error");
                }
            } else if (state == 2) {
                if (this.look == Word.RB) {
                    temp = ASTNode.EMPTY;
                    assert (astStack.peek() != null);
                    ((ASTNode)astStack.peek()).add(temp);
                    state = -1;
                    this.move();
                    continue;
                }
                if (this.look instanceof Word || this.look.tag == Tag.DA) {
                    if (this.look == Word.LB) {
                        --this.index;
                        this.lexTokens.add(this.index, Word.SP);
                        this.lexTokens.add(this.index, Word.STRUCTURE);
                        this.move();
                    }
                    temp = new ASTNode(this.look);
                    assert (astStack.peek() != null);
                    ((ASTNode)astStack.peek()).add(temp);
                    astStack.push(temp);
                    state = -1;
                } else {
                    this.error("nonstandard word error");
                }
            } else if (this.look == Word.LB) {
                state = astStack.isEmpty() ? 1 : 2;
            } else if (this.look == Word.RB) {
                if (this.index >= 3 && this.lexTokens.get(this.index - 3) == Word.LB) {
                    assert (astStack.peek() != null);
                    ((ASTNode)astStack.peek()).tag = ASTNode.AstTag.FUNCTION;
                }
                if (!astStack.isEmpty()) {
                    astStack.pop();
                } else {
                    this.error("separator mismatch error");
                }
            } else if (this.look != Word.SP) {
                if (!astStack.isEmpty()) {
                    ((ASTNode)astStack.peek()).add(new ASTNode(this.look));
                } else {
                    this.error("separator mismatch error");
                }
            }
            this.move();
        }
        return asts;
    }
}

