/*
 * Decompiled with CFR 0.152.
 */
package cn.wumoe.hime.module.properties;

import cn.wumoe.hime.lexer.Tag;
import cn.wumoe.hime.lexer.Token;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0086\u0002J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\b\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0003J!\u0010\u0010\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcn/wumoe/hime/module/properties/PropertiesToken;", "Lcn/wumoe/hime/lexer/Token;", "path", "", "(Ljava/lang/String;)V", "properties", "Ljava/util/Properties;", "get", "key", "defaultValue", "keys", "", "", "load", "", "remove", "set", "value", "comments", "hime"})
public class PropertiesToken
extends Token {
    @NotNull
    private final String path;
    @Nullable
    private Properties properties;

    public PropertiesToken(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        super(Tag.PROPERTIES);
        this.path = path;
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void load() {
        File file = new File(this.path);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            return;
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        Closeable closeable = new InputStreamReader((InputStream)new FileInputStream(this.path), StandardCharsets.UTF_8);
        Throwable throwable = null;
        try {
            InputStreamReader in = (InputStreamReader)closeable;
            boolean bl = false;
            Properties properties = this.properties = new Properties();
            Intrinsics.checkNotNull((Object)properties);
            properties.load(in);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String set(@NotNull String key, @NotNull String value, @NotNull String comments) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)comments, (String)"comments");
        Properties properties = this.properties;
        Intrinsics.checkNotNull((Object)properties);
        properties.setProperty(key, value);
        Closeable closeable = new FileOutputStream(this.path);
        Throwable throwable = null;
        try {
            FileOutputStream fileOutputStream = (FileOutputStream)closeable;
            boolean bl = false;
            Properties properties2 = this.properties;
            Intrinsics.checkNotNull((Object)properties2);
            properties2.store(fileOutputStream, comments);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return value;
    }

    @NotNull
    public final String get(@NotNull String key, @NotNull String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        Properties properties = this.properties;
        Intrinsics.checkNotNull((Object)properties);
        String string = properties.getProperty(key, defaultValue);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"properties!!.getProperty(key, defaultValue)");
        return string;
    }

    @NotNull
    public final Set<Object> keys() {
        Properties properties = this.properties;
        Intrinsics.checkNotNull((Object)properties);
        Set<Object> set = properties.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"properties!!.keys");
        return set;
    }

    public final void remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Properties properties = this.properties;
        Intrinsics.checkNotNull((Object)properties);
        properties.remove(key);
    }
}

