/*
 * Decompiled with CFR 0.152.
 */
package cn.wumoe.hime.module.http;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\"\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\fJ\"\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\f\u00a8\u0006\u000e"}, d2={"Lcn/wumoe/hime/module/http/HttpUtil;", "", "()V", "download", "", "url", "", "path", "get", "getBase64", "post", "parameterMap", "", "postBase64", "hime"})
public final class HttpUtil {
    @NotNull
    public static final HttpUtil INSTANCE = new HttpUtil();

    private HttpUtil() {
    }

    public final void download(@NotNull String url, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        int byteRead = 0;
        URLConnection uRLConnection = new URL(url).openConnection();
        Intrinsics.checkNotNullExpressionValue((Object)uRLConnection, (String)"URL(url).openConnection()");
        URLConnection conn = uRLConnection;
        InputStream inputStream = conn.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"conn.getInputStream()");
        InputStream inStream = inputStream;
        FileOutputStream fs = new FileOutputStream(path);
        byte[] buffer = new byte[1024];
        while (true) {
            int n;
            int it = n = inStream.read(buffer);
            boolean bl = false;
            byteRead = it;
            if (n == -1) break;
            fs.write(buffer, 0, byteRead);
        }
    }

    @NotNull
    public final String get(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        URLConnection urlConnection = new URL(url).openConnection();
        BufferedReader br = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), StandardCharsets.UTF_8));
        String line = null;
        StringBuilder builder = new StringBuilder();
        while (true) {
            String string;
            String it = string = br.readLine();
            boolean bl = false;
            line = it;
            if (string == null) break;
            builder.append(line).append("\n");
        }
        br.close();
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    @NotNull
    public final String post(@NotNull String url, @NotNull Map<String, String> parameterMap) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(parameterMap, (String)"parameterMap");
        URLConnection uRLConnection = new URL(url).openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("charset", "utf-8");
        PrintWriter pw = new PrintWriter(new BufferedOutputStream(httpURLConnection.getOutputStream()));
        StringBuilder parameter = new StringBuilder();
        for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            parameter.append("&").append(URLEncoder.encode(key, StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(value, StandardCharsets.UTF_8));
        }
        pw.write(parameter.toString());
        pw.flush();
        pw.close();
        BufferedReader br = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), StandardCharsets.UTF_8));
        String line = null;
        StringBuilder builder = new StringBuilder();
        while (true) {
            String string;
            String it = string = br.readLine();
            boolean bl = false;
            line = it;
            if (string == null) break;
            builder.append(line).append("\n");
        }
        br.close();
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    @NotNull
    public final String getBase64(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        URLConnection urlConnection = new URL(url).openConnection();
        InputStream input = urlConnection.getInputStream();
        byte[] value = input.readAllBytes();
        input.close();
        String string = Base64.getEncoder().encodeToString(value);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEncoder().encodeToString(value)");
        return string;
    }

    @NotNull
    public final String postBase64(@NotNull String url, @NotNull Map<String, String> parameterMap) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(parameterMap, (String)"parameterMap");
        URLConnection uRLConnection = new URL(url).openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("charset", "utf-8");
        PrintWriter pw = new PrintWriter(new BufferedOutputStream(httpURLConnection.getOutputStream()));
        StringBuilder parameter = new StringBuilder();
        for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            parameter.append("&").append(URLEncoder.encode(key, StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(value, StandardCharsets.UTF_8));
        }
        pw.write(parameter.toString());
        pw.flush();
        pw.close();
        InputStream input = httpURLConnection.getInputStream();
        byte[] value = input.readAllBytes();
        input.close();
        return Base64.getDecoder().decode(value).toString();
    }
}

