/*
 * Decompiled with CFR 0.152.
 */
package cn.wumoe.hime.module.deaw;

import cn.wumoe.hime.Config;
import cn.wumoe.hime.gui.GUI;
import cn.wumoe.hime.lexer.Tag;
import cn.wumoe.hime.lexer.Token;
import cn.wumoe.hime.module.KeyModule;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001d"}, d2={"Lcn/wumoe/hime/module/deaw/HimeDrawToken;", "Lcn/wumoe/hime/lexer/Token;", "width", "", "height", "(II)V", "component", "Lcn/wumoe/hime/module/deaw/HimeDrawToken$DrawComponent;", "getComponent", "()Lcn/wumoe/hime/module/deaw/HimeDrawToken$DrawComponent;", "frame", "Ljavax/swing/JFrame;", "getFrame", "()Ljavax/swing/JFrame;", "graphics", "Ljava/awt/Graphics2D;", "getGraphics", "()Ljava/awt/Graphics2D;", "setGraphics", "(Ljava/awt/Graphics2D;)V", "image", "Ljava/awt/image/BufferedImage;", "getImage", "()Ljava/awt/image/BufferedImage;", "setImage", "(Ljava/awt/image/BufferedImage;)V", "update", "", "DrawComponent", "hime"})
public final class HimeDrawToken
extends Token {
    @NotNull
    private final JFrame frame = new JFrame();
    @NotNull
    private BufferedImage image;
    @NotNull
    private Graphics2D graphics;
    @NotNull
    private final DrawComponent component;

    public HimeDrawToken(int width, int height) {
        super(Tag.DRAW);
        this.frame.setSize(width, height);
        this.frame.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(@NotNull WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void windowClosing(@NotNull WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                KeyModule.Companion.getProvider().reset();
                if (Config.GUI) {
                    GUI.thread.interrupt();
                }
            }

            @Override
            public void windowClosed(@NotNull WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void windowIconified(@NotNull WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void windowDeiconified(@NotNull WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void windowActivated(@NotNull WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void windowDeactivated(@NotNull WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        });
        this.frame.setResizable(false);
        this.frame.setVisible(true);
        this.image = new BufferedImage(width, height, 1);
        Graphics graphics = this.image.getGraphics();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Graphics2D graphics2D = this.image.createGraphics();
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"image.createGraphics()");
        this.graphics = graphics2D;
        BufferedImage bufferedImage = this.graphics.getDeviceConfiguration().createCompatibleImage(width, height, 3);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"graphics.deviceConfigura\u2026Transparency.TRANSLUCENT)");
        this.image = bufferedImage;
        this.graphics.dispose();
        Graphics2D graphics2D2 = this.image.createGraphics();
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D2, (String)"image.createGraphics()");
        this.graphics = graphics2D2;
        this.graphics.setColor(Color.BLACK);
        this.component = new DrawComponent(this, width, height);
        this.frame.add(this.component);
    }

    @NotNull
    public final JFrame getFrame() {
        return this.frame;
    }

    @NotNull
    public final BufferedImage getImage() {
        return this.image;
    }

    public final void setImage(@NotNull BufferedImage bufferedImage) {
        Intrinsics.checkNotNullParameter((Object)bufferedImage, (String)"<set-?>");
        this.image = bufferedImage;
    }

    @NotNull
    public final Graphics2D getGraphics() {
        return this.graphics;
    }

    public final void setGraphics(@NotNull Graphics2D graphics2D) {
        Intrinsics.checkNotNullParameter((Object)graphics2D, (String)"<set-?>");
        this.graphics = graphics2D;
    }

    @NotNull
    public final DrawComponent getComponent() {
        return this.component;
    }

    public final void update() {
        this.frame.repaint();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcn/wumoe/hime/module/deaw/HimeDrawToken$DrawComponent;", "Ljavax/swing/JComponent;", "draw", "Lcn/wumoe/hime/module/deaw/HimeDrawToken;", "width", "", "height", "(Lcn/wumoe/hime/module/deaw/HimeDrawToken;II)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "hime"})
    public static final class DrawComponent
    extends JComponent {
        @NotNull
        private final HimeDrawToken draw;

        public DrawComponent(@NotNull HimeDrawToken draw, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)draw, (String)"draw");
            this.draw = draw;
            this.setPreferredSize(new Dimension(width, height));
        }

        @Override
        public void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(this.draw.getImage(), null, null);
        }
    }
}

