/*
 * Decompiled with CFR 0.152.
 */
package cn.wumoe.hime.module.deaw;

import cn.wumoe.hime.api.scripting.HimeContext;
import cn.wumoe.hime.inter.Function;
import cn.wumoe.hime.inter.Module;
import cn.wumoe.hime.lexer.Array;
import cn.wumoe.hime.lexer.Num;
import cn.wumoe.hime.lexer.Token;
import cn.wumoe.hime.lexer.Word;
import cn.wumoe.hime.module.deaw.HimeDrawToken;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001:\u0010\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0017"}, d2={"Lcn/wumoe/hime/module/deaw/DrawModule;", "Lcn/wumoe/hime/inter/Module;", "()V", "init", "", "context", "Lcn/wumoe/hime/api/scripting/HimeContext;", "Clear", "Color", "Draw", "DrawArc", "DrawImg", "DrawLine", "DrawOval", "DrawPolygon", "DrawRect", "DrawRectRound", "DrawWord", "FillArc", "FillOval", "FillPolygon", "FillRect", "FillRectRound", "hime"})
public final class DrawModule
extends Module {
    public DrawModule() {
        super("hime.draw");
    }

    @Override
    public void init(@NotNull HimeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.addFunction(new Draw());
        this.addFunction(new Color());
        this.addFunction(new Clear());
        this.addFunction(new DrawLine());
        this.addFunction(new DrawRect());
        this.addFunction(new DrawRectRound());
        this.addFunction(new FillRect());
        this.addFunction(new FillRectRound());
        this.addFunction(new DrawArc());
        this.addFunction(new FillArc());
        this.addFunction(new DrawOval());
        this.addFunction(new FillOval());
        this.addFunction(new DrawWord());
        this.addFunction(new DrawPolygon());
        this.addFunction(new FillPolygon());
        this.addFunction(new DrawImg());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/deaw/DrawModule$DrawImg;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class DrawImg
    extends Function {
        public DrawImg() {
            super("draw-img");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 4 && pars[0] instanceof HimeDrawToken && pars[1] instanceof Array && pars[2] instanceof Array) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.deaw.HimeDrawToken");
                HimeDrawToken draw = (HimeDrawToken)token;
                Token token2 = pars[1];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p1 = (Array)token2;
                Token token3 = pars[2];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p2 = (Array)token3;
                if (p1.get(0) instanceof Num && p1.get(1) instanceof Num && p2.get(0) instanceof Num && p2.get(1) instanceof Num) {
                    Token token4 = p1.get(0);
                    Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int x = ((Num)token4).value.intValueExact();
                    Token token5 = p1.get(1);
                    Intrinsics.checkNotNull((Object)token5, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int y = ((Num)token5).value.intValueExact();
                    Token token6 = p2.get(0);
                    Intrinsics.checkNotNull((Object)token6, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int width = ((Num)token6).value.intValueExact();
                    Token token7 = p2.get(1);
                    Intrinsics.checkNotNull((Object)token7, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int height = ((Num)token7).value.intValueExact();
                    InputStream buff = new ByteArrayInputStream(Base64.getDecoder().decode(pars[3].toString()));
                    BufferedImage img = ImageIO.read(buff);
                    Graphics2D graphics = draw.getGraphics();
                    graphics.drawImage(img, x, y, width, height, draw.getComponent());
                    draw.update();
                }
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/deaw/DrawModule$Draw;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Draw
    extends Function {
        public Draw() {
            super("draw");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2 && pars[0] instanceof Num && pars[1] instanceof Num) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                int n = ((Num)token2).value.intValueExact();
                Token token3 = pars[1];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                token = new HimeDrawToken(n, ((Num)token3).value.intValueExact());
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/deaw/DrawModule$Color;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Color
    extends Function {
        public Color() {
            super("draw-color");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 4 && pars[0] instanceof HimeDrawToken && pars[1] instanceof Num && pars[2] instanceof Num && pars[3] instanceof Num) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.deaw.HimeDrawToken");
                Graphics2D graphics2D = ((HimeDrawToken)token).getGraphics();
                Token token2 = pars[1];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                int n = ((Num)token2).value.intValueExact();
                Token token3 = pars[2];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                int n2 = ((Num)token3).value.intValueExact();
                Token token4 = pars[3];
                Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                graphics2D.setColor(new java.awt.Color(n, n2, ((Num)token4).value.intValueExact()));
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/deaw/DrawModule$Clear;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Clear
    extends Function {
        public Clear() {
            super("draw-clear");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length == 1 && pars[0] instanceof HimeDrawToken) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.deaw.HimeDrawToken");
                HimeDrawToken draw = (HimeDrawToken)token;
                draw.setImage(new BufferedImage(draw.getFrame().getWidth(), draw.getFrame().getHeight(), 1));
                Graphics graphics = draw.getImage().getGraphics();
                Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Graphics2D graphics2D = draw.getImage().createGraphics();
                Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"draw.image.createGraphics()");
                draw.setGraphics(graphics2D);
                BufferedImage bufferedImage = draw.getGraphics().getDeviceConfiguration().createCompatibleImage(draw.getFrame().getWidth(), draw.getFrame().getHeight(), 3);
                Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"draw.graphics.deviceConf\u2026Transparency.TRANSLUCENT)");
                draw.setImage(bufferedImage);
                draw.getGraphics().dispose();
                Graphics2D graphics2D2 = draw.getImage().createGraphics();
                Intrinsics.checkNotNullExpressionValue((Object)graphics2D2, (String)"draw.image.createGraphics()");
                draw.setGraphics(graphics2D2);
                draw.getGraphics().setColor(java.awt.Color.BLACK);
            } else if (pars.length >= 3 && pars[0] instanceof HimeDrawToken && pars[1] instanceof Array && pars[2] instanceof Array) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.deaw.HimeDrawToken");
                HimeDrawToken draw = (HimeDrawToken)token;
                Token token2 = pars[1];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p1 = (Array)token2;
                Token token3 = pars[2];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p2 = (Array)token3;
                if (p1.get(0) instanceof Num && p1.get(1) instanceof Num && p2.get(0) instanceof Num && p2.get(1) instanceof Num) {
                    Token token4 = p1.get(0);
                    Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int x = ((Num)token4).value.intValueExact();
                    Token token5 = p1.get(1);
                    Intrinsics.checkNotNull((Object)token5, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int y = ((Num)token5).value.intValueExact();
                    Token token6 = p2.get(0);
                    Intrinsics.checkNotNull((Object)token6, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int width = ((Num)token6).value.intValueExact();
                    Token token7 = p2.get(1);
                    Intrinsics.checkNotNull((Object)token7, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int height = ((Num)token7).value.intValueExact();
                    Graphics2D graphics = draw.getGraphics();
                    graphics.clearRect(x, y, width, height);
                    draw.update();
                }
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/deaw/DrawModule$DrawPolygon;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class DrawPolygon
    extends Function {
        public DrawPolygon() {
            super("draw-polygon");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2 && pars[0] instanceof HimeDrawToken && pars[1] instanceof Array) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.deaw.HimeDrawToken");
                HimeDrawToken draw = (HimeDrawToken)token;
                Token token2 = pars[1];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p1 = (Array)token2;
                ArrayList<Integer> xa = new ArrayList<Integer>();
                ArrayList<Integer> ya = new ArrayList<Integer>();
                for (Token p : p1.tokens) {
                    Intrinsics.checkNotNull((Object)p, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                    Array array = (Array)p;
                    Token token3 = array.get(0);
                    Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    xa.add(((Num)token3).value.intValueExact());
                    Token token4 = array.get(1);
                    Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    ya.add(((Num)token4).value.intValueExact());
                }
                Graphics2D graphics = draw.getGraphics();
                graphics.drawPolygon(CollectionsKt.toIntArray((Collection)xa), CollectionsKt.toIntArray((Collection)ya), RangesKt.coerceAtMost((int)xa.size(), (int)ya.size()));
                draw.update();
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/deaw/DrawModule$FillPolygon;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class FillPolygon
    extends Function {
        public FillPolygon() {
            super("fill-polygon");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2 && pars[0] instanceof HimeDrawToken && pars[1] instanceof Array) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.deaw.HimeDrawToken");
                HimeDrawToken draw = (HimeDrawToken)token;
                Token token2 = pars[1];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p1 = (Array)token2;
                ArrayList<Integer> xa = new ArrayList<Integer>();
                ArrayList<Integer> ya = new ArrayList<Integer>();
                for (Token p : p1.tokens) {
                    Intrinsics.checkNotNull((Object)p, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                    Array array = (Array)p;
                    Token token3 = array.get(0);
                    Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    xa.add(((Num)token3).value.intValueExact());
                    Token token4 = array.get(1);
                    Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    ya.add(((Num)token4).value.intValueExact());
                }
                Graphics2D graphics = draw.getGraphics();
                graphics.fillPolygon(CollectionsKt.toIntArray((Collection)xa), CollectionsKt.toIntArray((Collection)ya), RangesKt.coerceAtMost((int)xa.size(), (int)ya.size()));
                draw.update();
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/deaw/DrawModule$DrawLine;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class DrawLine
    extends Function {
        public DrawLine() {
            super("draw-line");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 3 && pars[0] instanceof HimeDrawToken && pars[1] instanceof Array && pars[2] instanceof Array) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.deaw.HimeDrawToken");
                HimeDrawToken draw = (HimeDrawToken)token;
                Token token2 = pars[1];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p1 = (Array)token2;
                Token token3 = pars[2];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p2 = (Array)token3;
                if (p1.get(0) instanceof Num && p1.get(1) instanceof Num && p2.get(0) instanceof Num && p2.get(1) instanceof Num) {
                    Token token4 = p1.get(0);
                    Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int x1 = ((Num)token4).value.intValueExact();
                    Token token5 = p1.get(1);
                    Intrinsics.checkNotNull((Object)token5, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int y1 = ((Num)token5).value.intValueExact();
                    Token token6 = p2.get(0);
                    Intrinsics.checkNotNull((Object)token6, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int x2 = ((Num)token6).value.intValueExact();
                    Token token7 = p2.get(1);
                    Intrinsics.checkNotNull((Object)token7, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int y2 = ((Num)token7).value.intValueExact();
                    Graphics2D graphics = draw.getGraphics();
                    graphics.drawLine(x1, y1, x2, y2);
                    draw.update();
                }
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/deaw/DrawModule$DrawWord;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class DrawWord
    extends Function {
        public DrawWord() {
            super("draw-word");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 3 && pars[0] instanceof HimeDrawToken && pars[1] instanceof Array) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.deaw.HimeDrawToken");
                HimeDrawToken draw = (HimeDrawToken)token;
                Token token2 = pars[1];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p1 = (Array)token2;
                if (p1.get(0) instanceof Num && p1.get(1) instanceof Num) {
                    Token token3 = p1.get(0);
                    Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int x = ((Num)token3).value.intValueExact();
                    Token token4 = p1.get(1);
                    Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int y = ((Num)token4).value.intValueExact();
                    String string = pars[2].toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pars[2].toString()");
                    String word = string;
                    Graphics2D graphics = draw.getGraphics();
                    graphics.drawString(word, x, y);
                    draw.update();
                }
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/deaw/DrawModule$DrawRect;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class DrawRect
    extends Function {
        public DrawRect() {
            super("draw-rect");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 3 && pars[0] instanceof HimeDrawToken && pars[1] instanceof Array && pars[2] instanceof Array) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.deaw.HimeDrawToken");
                HimeDrawToken draw = (HimeDrawToken)token;
                Token token2 = pars[1];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p1 = (Array)token2;
                Token token3 = pars[2];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p2 = (Array)token3;
                if (p1.get(0) instanceof Num && p1.get(1) instanceof Num && p2.get(0) instanceof Num && p2.get(1) instanceof Num) {
                    Token token4 = p1.get(0);
                    Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int x = ((Num)token4).value.intValueExact();
                    Token token5 = p1.get(1);
                    Intrinsics.checkNotNull((Object)token5, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int y = ((Num)token5).value.intValueExact();
                    Token token6 = p2.get(0);
                    Intrinsics.checkNotNull((Object)token6, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int width = ((Num)token6).value.intValueExact();
                    Token token7 = p2.get(1);
                    Intrinsics.checkNotNull((Object)token7, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int height = ((Num)token7).value.intValueExact();
                    Graphics2D graphics = draw.getGraphics();
                    graphics.drawRect(x, y, width, height);
                    draw.update();
                }
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/deaw/DrawModule$FillRect;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class FillRect
    extends Function {
        public FillRect() {
            super("fill-rect");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 3 && pars[0] instanceof HimeDrawToken && pars[1] instanceof Array && pars[2] instanceof Array) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.deaw.HimeDrawToken");
                HimeDrawToken draw = (HimeDrawToken)token;
                Token token2 = pars[1];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p1 = (Array)token2;
                Token token3 = pars[2];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p2 = (Array)token3;
                if (p1.get(0) instanceof Num && p1.get(1) instanceof Num && p2.get(0) instanceof Num && p2.get(1) instanceof Num) {
                    Token token4 = p1.get(0);
                    Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int x = ((Num)token4).value.intValueExact();
                    Token token5 = p1.get(1);
                    Intrinsics.checkNotNull((Object)token5, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int y = ((Num)token5).value.intValueExact();
                    Token token6 = p2.get(0);
                    Intrinsics.checkNotNull((Object)token6, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int width = ((Num)token6).value.intValueExact();
                    Token token7 = p2.get(1);
                    Intrinsics.checkNotNull((Object)token7, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int height = ((Num)token7).value.intValueExact();
                    Graphics2D graphics = draw.getGraphics();
                    graphics.fillRect(x, y, width, height);
                    draw.update();
                }
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/deaw/DrawModule$DrawRectRound;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class DrawRectRound
    extends Function {
        public DrawRectRound() {
            super("draw-rect-round");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 4 && pars[0] instanceof HimeDrawToken && pars[1] instanceof Array && pars[2] instanceof Array && pars[3] instanceof Array) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.deaw.HimeDrawToken");
                HimeDrawToken draw = (HimeDrawToken)token;
                Token token2 = pars[1];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p1 = (Array)token2;
                Token token3 = pars[2];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p2 = (Array)token3;
                Token token4 = pars[3];
                Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p3 = (Array)token4;
                if (p1.get(0) instanceof Num && p1.get(1) instanceof Num && p2.get(0) instanceof Num && p2.get(1) instanceof Num && p3.get(0) instanceof Num && p3.get(1) instanceof Num) {
                    Token token5 = p1.get(0);
                    Intrinsics.checkNotNull((Object)token5, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int x = ((Num)token5).value.intValueExact();
                    Token token6 = p1.get(1);
                    Intrinsics.checkNotNull((Object)token6, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int y = ((Num)token6).value.intValueExact();
                    Token token7 = p2.get(0);
                    Intrinsics.checkNotNull((Object)token7, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int width = ((Num)token7).value.intValueExact();
                    Token token8 = p2.get(1);
                    Intrinsics.checkNotNull((Object)token8, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int height = ((Num)token8).value.intValueExact();
                    Token token9 = p3.get(0);
                    Intrinsics.checkNotNull((Object)token9, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int arcWidth = ((Num)token9).value.intValueExact();
                    Token token10 = p3.get(1);
                    Intrinsics.checkNotNull((Object)token10, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int arcHeight = ((Num)token10).value.intValueExact();
                    Graphics2D graphics = draw.getGraphics();
                    graphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
                    draw.update();
                }
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/deaw/DrawModule$FillRectRound;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class FillRectRound
    extends Function {
        public FillRectRound() {
            super("fill-rect-round");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 4 && pars[0] instanceof HimeDrawToken && pars[1] instanceof Array && pars[2] instanceof Array && pars[3] instanceof Array) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.deaw.HimeDrawToken");
                HimeDrawToken draw = (HimeDrawToken)token;
                Token token2 = pars[1];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p1 = (Array)token2;
                Token token3 = pars[2];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p2 = (Array)token3;
                Token token4 = pars[3];
                Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p3 = (Array)token4;
                if (p1.get(0) instanceof Num && p1.get(1) instanceof Num && p2.get(0) instanceof Num && p2.get(1) instanceof Num && p3.get(0) instanceof Num && p3.get(1) instanceof Num) {
                    Token token5 = p1.get(0);
                    Intrinsics.checkNotNull((Object)token5, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int x = ((Num)token5).value.intValueExact();
                    Token token6 = p1.get(1);
                    Intrinsics.checkNotNull((Object)token6, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int y = ((Num)token6).value.intValueExact();
                    Token token7 = p2.get(0);
                    Intrinsics.checkNotNull((Object)token7, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int width = ((Num)token7).value.intValueExact();
                    Token token8 = p2.get(1);
                    Intrinsics.checkNotNull((Object)token8, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int height = ((Num)token8).value.intValueExact();
                    Token token9 = p3.get(0);
                    Intrinsics.checkNotNull((Object)token9, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int arcWidth = ((Num)token9).value.intValueExact();
                    Token token10 = p3.get(1);
                    Intrinsics.checkNotNull((Object)token10, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int arcHeight = ((Num)token10).value.intValueExact();
                    Graphics2D graphics = draw.getGraphics();
                    graphics.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
                    draw.update();
                }
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/deaw/DrawModule$DrawArc;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class DrawArc
    extends Function {
        public DrawArc() {
            super("draw-arc");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 4 && pars[0] instanceof HimeDrawToken && pars[1] instanceof Array && pars[2] instanceof Array && pars[3] instanceof Array) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.deaw.HimeDrawToken");
                HimeDrawToken draw = (HimeDrawToken)token;
                Token token2 = pars[1];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p1 = (Array)token2;
                Token token3 = pars[2];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p2 = (Array)token3;
                Token token4 = pars[3];
                Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p3 = (Array)token4;
                if (p1.get(0) instanceof Num && p1.get(1) instanceof Num && p2.get(0) instanceof Num && p2.get(1) instanceof Num && p3.get(0) instanceof Num && p3.get(1) instanceof Num) {
                    Token token5 = p1.get(0);
                    Intrinsics.checkNotNull((Object)token5, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int x = ((Num)token5).value.intValueExact();
                    Token token6 = p1.get(1);
                    Intrinsics.checkNotNull((Object)token6, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int y = ((Num)token6).value.intValueExact();
                    Token token7 = p2.get(0);
                    Intrinsics.checkNotNull((Object)token7, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int width = ((Num)token7).value.intValueExact();
                    Token token8 = p2.get(1);
                    Intrinsics.checkNotNull((Object)token8, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int height = ((Num)token8).value.intValueExact();
                    Token token9 = p3.get(0);
                    Intrinsics.checkNotNull((Object)token9, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int startAngle = ((Num)token9).value.intValueExact();
                    Token token10 = p3.get(1);
                    Intrinsics.checkNotNull((Object)token10, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int arcAngle = ((Num)token10).value.intValueExact();
                    Graphics2D graphics = draw.getGraphics();
                    graphics.drawArc(x, y, width, height, startAngle, arcAngle);
                    draw.update();
                }
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/deaw/DrawModule$FillArc;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class FillArc
    extends Function {
        public FillArc() {
            super("fill-arc");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 4 && pars[0] instanceof HimeDrawToken && pars[1] instanceof Array && pars[2] instanceof Array && pars[3] instanceof Array) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.deaw.HimeDrawToken");
                HimeDrawToken draw = (HimeDrawToken)token;
                Token token2 = pars[1];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p1 = (Array)token2;
                Token token3 = pars[2];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p2 = (Array)token3;
                Token token4 = pars[3];
                Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p3 = (Array)token4;
                if (p1.get(0) instanceof Num && p1.get(1) instanceof Num && p2.get(0) instanceof Num && p2.get(1) instanceof Num && p3.get(0) instanceof Num && p3.get(1) instanceof Num) {
                    Token token5 = p1.get(0);
                    Intrinsics.checkNotNull((Object)token5, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int x = ((Num)token5).value.intValueExact();
                    Token token6 = p1.get(1);
                    Intrinsics.checkNotNull((Object)token6, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int y = ((Num)token6).value.intValueExact();
                    Token token7 = p2.get(0);
                    Intrinsics.checkNotNull((Object)token7, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int width = ((Num)token7).value.intValueExact();
                    Token token8 = p2.get(1);
                    Intrinsics.checkNotNull((Object)token8, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int height = ((Num)token8).value.intValueExact();
                    Token token9 = p3.get(0);
                    Intrinsics.checkNotNull((Object)token9, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int startAngle = ((Num)token9).value.intValueExact();
                    Token token10 = p3.get(1);
                    Intrinsics.checkNotNull((Object)token10, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int arcAngle = ((Num)token10).value.intValueExact();
                    Graphics2D graphics = draw.getGraphics();
                    graphics.fillArc(x, y, width, height, startAngle, arcAngle);
                    draw.update();
                }
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/deaw/DrawModule$DrawOval;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class DrawOval
    extends Function {
        public DrawOval() {
            super("draw-oval");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 3 && pars[0] instanceof HimeDrawToken && pars[1] instanceof Array && pars[2] instanceof Array) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.deaw.HimeDrawToken");
                HimeDrawToken draw = (HimeDrawToken)token;
                Token token2 = pars[1];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p1 = (Array)token2;
                Token token3 = pars[2];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p2 = (Array)token3;
                if (p1.get(0) instanceof Num && p1.get(1) instanceof Num && p2.get(0) instanceof Num && p2.get(1) instanceof Num) {
                    Token token4 = p1.get(0);
                    Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int x = ((Num)token4).value.intValueExact();
                    Token token5 = p1.get(1);
                    Intrinsics.checkNotNull((Object)token5, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int y = ((Num)token5).value.intValueExact();
                    Token token6 = p2.get(0);
                    Intrinsics.checkNotNull((Object)token6, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int width = ((Num)token6).value.intValueExact();
                    Token token7 = p2.get(1);
                    Intrinsics.checkNotNull((Object)token7, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int height = ((Num)token7).value.intValueExact();
                    Graphics2D graphics = draw.getGraphics();
                    graphics.drawOval(x, y, width, height);
                    draw.update();
                }
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/deaw/DrawModule$FillOval;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class FillOval
    extends Function {
        public FillOval() {
            super("fill-oval");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 3 && pars[0] instanceof HimeDrawToken && pars[1] instanceof Array && pars[2] instanceof Array) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.deaw.HimeDrawToken");
                HimeDrawToken draw = (HimeDrawToken)token;
                Token token2 = pars[1];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p1 = (Array)token2;
                Token token3 = pars[2];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array p2 = (Array)token3;
                if (p1.get(0) instanceof Num && p1.get(1) instanceof Num && p2.get(0) instanceof Num && p2.get(1) instanceof Num) {
                    Token token4 = p1.get(0);
                    Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int x = ((Num)token4).value.intValueExact();
                    Token token5 = p1.get(1);
                    Intrinsics.checkNotNull((Object)token5, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int y = ((Num)token5).value.intValueExact();
                    Token token6 = p2.get(0);
                    Intrinsics.checkNotNull((Object)token6, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int width = ((Num)token6).value.intValueExact();
                    Token token7 = p2.get(1);
                    Intrinsics.checkNotNull((Object)token7, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    int height = ((Num)token7).value.intValueExact();
                    Graphics2D graphics = draw.getGraphics();
                    graphics.fillOval(x, y, width, height);
                    draw.update();
                }
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }
}

