/*
 * Decompiled with CFR 0.152.
 */
package cn.wumoe.hime.module;

import cn.wumoe.hime.KotlinExtendKt;
import cn.wumoe.hime.api.scripting.HimeContext;
import cn.wumoe.hime.inter.Function;
import cn.wumoe.hime.inter.Module;
import cn.wumoe.hime.lexer.Num;
import cn.wumoe.hime.lexer.Token;
import cn.wumoe.hime.lexer.Word;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0007\b\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcn/wumoe/hime/module/QRCodeModule;", "Lcn/wumoe/hime/inter/Module;", "()V", "init", "", "context", "Lcn/wumoe/hime/api/scripting/HimeContext;", "QRCodeDecode", "QRCodeEncode", "QRCodeEncodeLogo", "hime"})
public final class QRCodeModule
extends Module {
    public QRCodeModule() {
        super("hime.qrcode");
    }

    @Override
    public void init(@NotNull HimeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.addFunction(new QRCodeEncodeLogo());
        this.addFunction(new QRCodeEncode());
        this.addFunction(new QRCodeDecode());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/QRCodeModule$QRCodeDecode;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class QRCodeDecode
    extends Function {
        public QRCodeDecode() {
            super("qrcode-decode");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                MultiFormatReader formatReader = new MultiFormatReader();
                BufferedImage image = ImageIO.read(new ByteArrayInputStream(Base64.getDecoder().decode(pars[0].toString())));
                BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)new BufferedImageLuminanceSource(image)));
                HashMap hints = new HashMap();
                Map map = hints;
                DecodeHintType decodeHintType = DecodeHintType.CHARACTER_SET;
                String string = StandardCharsets.UTF_8.displayName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UTF_8.displayName()");
                String string2 = string;
                map.put(decodeHintType, string2);
                Result result = formatReader.decode(binaryBitmap, (Map)hints);
                String string3 = result.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"result.text");
                token = KotlinExtendKt.toWord(string3);
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/QRCodeModule$QRCodeEncodeLogo;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class QRCodeEncodeLogo
    extends Function {
        public QRCodeEncodeLogo() {
            super("qrcode-encode-logo");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 4 && pars[0] instanceof Num) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                int qrcodeSize = ((Num)token2).value.intValue();
                Token token3 = pars[1];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                int logoSize = ((Num)token3).value.intValue();
                String string = pars[3].toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pars[3].toString()");
                String content = string;
                HashMap hints = new HashMap();
                ((Map)hints).put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
                Map map = hints;
                EncodeHintType encodeHintType = EncodeHintType.CHARACTER_SET;
                String string2 = StandardCharsets.UTF_8.displayName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"UTF_8.displayName()");
                String string3 = string2;
                map.put(encodeHintType, string3);
                ((Map)hints).put(EncodeHintType.MARGIN, 1);
                BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, qrcodeSize, qrcodeSize, (Map)hints);
                BufferedImage image = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
                BufferedImage logoImage = ImageIO.read(new ByteArrayInputStream(Base64.getDecoder().decode(pars[2].toString())));
                Graphics2D graphics2D = image.createGraphics();
                int x = (qrcodeSize - logoSize) / 2;
                int y = (qrcodeSize - logoSize) / 2;
                graphics2D.drawImage(logoImage, x, y, logoSize, logoSize, null);
                RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x, y, logoSize, logoSize, 6.0f, 6.0f);
                graphics2D.setStroke(new BasicStroke(3.0f));
                graphics2D.draw(shape);
                graphics2D.dispose();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)image, "png", byteArrayOutputStream);
                String string4 = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getEncoder().encodeToStr\u2026tputStream.toByteArray())");
                token = KotlinExtendKt.toWord(string4);
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/QRCodeModule$QRCodeEncode;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class QRCodeEncode
    extends Function {
        public QRCodeEncode() {
            super("qrcode-encode");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2 && pars[0] instanceof Num) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                int size = ((Num)token2).value.intValue();
                String string = pars[1].toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pars[1].toString()");
                String content = string;
                HashMap hints = new HashMap();
                ((Map)hints).put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
                Map map = hints;
                EncodeHintType encodeHintType = EncodeHintType.CHARACTER_SET;
                String string2 = StandardCharsets.UTF_8.displayName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"UTF_8.displayName()");
                String string3 = string2;
                map.put(encodeHintType, string3);
                ((Map)hints).put(EncodeHintType.MARGIN, 1);
                BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, size, size, (Map)hints);
                BufferedImage image = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)image, "png", byteArrayOutputStream);
                String string4 = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getEncoder().encodeToStr\u2026tputStream.toByteArray())");
                token = KotlinExtendKt.toWord(string4);
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }
}

