/*
 * Decompiled with CFR 0.152.
 */
package cn.wumoe.hime.inter;

import cn.wumoe.hime.api.scripting.HimeContext;
import cn.wumoe.hime.inter.Function;
import cn.wumoe.hime.lexer.Tag;
import cn.wumoe.hime.lexer.Token;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class Module
extends Token {
    public final String path;
    public final List<Function> functions;
    public final Map<String, Token> variableMap;

    public Module(String path) {
        super(Tag.LIBRARY);
        this.path = path;
        this.functions = new CopyOnWriteArrayList<Function>();
        this.variableMap = new ConcurrentHashMap<String, Token>();
        this.init(new HimeContext());
    }

    public Module(String path, HimeContext context) {
        super(Tag.LIBRARY);
        this.path = path;
        this.functions = new CopyOnWriteArrayList<Function>();
        this.variableMap = new ConcurrentHashMap<String, Token>();
        this.init(context);
    }

    public abstract void init(HimeContext var1);

    public void addFunction(Function f) {
        this.functions.add(f);
    }

    public void addVariable(String key, Token token) {
        this.variableMap.put(key, token);
    }

    public int size() {
        return this.functions.size();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Module module2 = (Module)o;
        return this.path.equals(module2.path) && this.functions.equals(module2.functions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.path, this.functions);
    }
}

