package cn.wumoe.hime.semantic;

import cn.wumoe.hime.exceptions.HimeParserException;
import cn.wumoe.hime.inter.ASTNode;
import cn.wumoe.hime.lexer.Word;
import cn.wumoe.hime.exceptions.HimeParserException;
import cn.wumoe.hime.inter.ASTNode;
import cn.wumoe.hime.inter.Function;
import cn.wumoe.hime.inter.Module;
import cn.wumoe.hime.lexer.Tag;
import cn.wumoe.hime.lexer.Token;
import cn.wumoe.hime.lexer.Word;
import com.beust.ah.A;

import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;

public class Analysis {
    public final static SymbolList overallData;
    public final Deque<SymbolList> dataStack;
    public SymbolList head;
    public Analysis father;
    public boolean end;
    public boolean eval;
    public static Module module;
    public static Module require;

    static {
        overallData = new SymbolList(new ConcurrentHashMap<>(), new ConcurrentHashMap<>(), ASTNode.EMPTY, null, new Analysis());
    }

    public Analysis(SymbolList data) {
        dataStack = new LinkedBlockingDeque<>();
        head = data;
        dataStack.push(head);
        this.father = null;
        this.eval = false;
    }

    public Analysis() {
        dataStack = new LinkedBlockingDeque<>();
        head = new SymbolList(new ConcurrentHashMap<>(), new ConcurrentHashMap<>(), ASTNode.EMPTY, overallData, this);
        dataStack.push(head);
        this.father = null;
        this.eval = false;
    }

    public Analysis copy() {
        Analysis temp = new Analysis();
        temp.head.setFather(this.head);
        temp.father = this;
        return temp;
    }

    public boolean isEnd() {
        Analysis analysis = this;
        while (analysis != null && !analysis.end) {
            analysis = analysis.father;
        }
        return analysis != null;
    }

    public void endToFalse() {
        Analysis analysis = this;
        while (analysis != null && !analysis.end) {
            analysis = analysis.father;
        }
        if (analysis != null)
            analysis.end = false;
    }

    void error() throws HimeParserException {
        throw new HimeParserException("SymbolList Eq Null!");
    }

    public void addModule(Module module) {
        this.head.addModule(module);
    }

    public void addFunction(Function function) {
        this.head.addFunction(function);
    }

    public void addVariable(String key, Token value) {
        this.head.addVariable(key, value);
    }

    public void removeModule(Module module) {
        this.head.removeModule(module);
    }

    public void removeFunction(Function function) {
        this.head.removeFunction(function);
    }

    public void removeVariable(String key) {
        this.head.removeVariable(key);
    }

    public Token getVariable(String name) {
        return this.head.getVariable(name);
    }

    public Function getFunction(String name) {
        return this.head.getFunction(name);
    }

    public Module getModule(String name) {
        return this.head.getModule(name);
    }

    public boolean containsVariable(String name) {
        return this.head.containsVariable(name);
    }

    public boolean containsFunction(String name) {
        return this.head.containsFunction(name);
    }

    public boolean containsModule(String name) {
        return this.head.containsModule(name);
    }

    public void call(ASTNode node) throws HimeParserException {
        head.setAstNode(node);
        top:
        while (true) {
            if (dataStack.isEmpty()) {
                dataStack.push(head);
            }
            SymbolList data = dataStack.peek();
            if (data == null) {
                error();
                return;
            }
            ASTNode ast = data.getAstNode();
            Token tempToken = ast.tok;
            while (true) {
                assert tempToken != null;
                if (data.containsVariable(tempToken.toString())) {
                    if (data.getVariable(tempToken.toString()) instanceof Function)
                        break;
                    tempToken = data.getVariable(tempToken.toString());
                } else
                    break;
            }
            ast.tok = tempToken;

            if (ast.tok.tag == Tag.STRUCTURE && ast.size() >= 1) {
                Analysis temp = this.copy();
                temp.call(ast.get(0));
                ast.tok = ast.get(0).tok;
                ast.remove(ast.get(0));
            }
            if (data.containsFunction(ast.tok.toString()) && ast.tok.tag == Tag.ID) {
                Function func = data.getFunction(ast.tok.toString());
                assert func != null;
                func.analysis = this;
                if (!func.keep) {
                    for (int i = 0; i < ast.size(); ++i) {
                        ASTNode next = ast.get(i);
                        assert next.tok != null;
                        tempToken = next.tok;
                        while (true) {
                            assert tempToken != null;
                            if (data.containsVariable(tempToken.toString())) {
                                if (data.getVariable(tempToken.toString()) instanceof Function
                                        || data.getVariable(tempToken.toString()) instanceof ASTNode)
                                    break;
                                tempToken = data.getVariable(tempToken.toString());
                            } else
                                break;
                        }
                        next.tok = tempToken;

                        if (next.tag == ASTNode.AstTag.FUNCTION) {
                            Function function = data.getFunction(next.tok.toString());
                            assert function != null;
                            function.analysis = this;
                            next.tok = function.call(new Token[]{});
                            next.tag = ASTNode.AstTag.BASIC;
                        }
                        if (next.size() > 0) {
                            dataStack.push(new SymbolList(new ConcurrentHashMap<>(), new ConcurrentHashMap<>(), next, data, this));
                            continue top;
                        }
                    }
                }

                Token[] tokens = new Token[func.keep ? 2 : ast.size()];
                if (func.keep) {
                    tokens[0] = ast;
                    tokens[1] = eval? Objects.requireNonNull(data.getFather()).getFather(): data;
                } else {
                    for (int i = 0; i < ast.size(); ++i)
                        tokens[i] = ast.get(i).tok;
                }
                ast.tok = func.call(tokens);
                ast.clear();
            }
            if ("module".equals(ast.tok.toString()) && module != null) {
                require = module;
                module = null;
            }
            dataStack.pop();
            if (dataStack.isEmpty()) {
                break;
            }
        }
    }
}
