package cn.wumoe.hime.module.deaw

import cn.wumoe.hime.Config
import cn.wumoe.hime.gui.GUI
import cn.wumoe.hime.lexer.Tag
import cn.wumoe.hime.lexer.Token
import cn.wumoe.hime.module.KeyModule.Companion.provider
import java.awt.*
import java.awt.event.WindowEvent
import java.awt.event.WindowListener
import java.awt.image.BufferedImage
import javax.swing.JComponent
import javax.swing.JFrame


class HimeDrawToken(width: Int, height: Int) : Token(Tag.DRAW) {
    val frame: JFrame = JFrame()
    var image: BufferedImage
    var graphics: Graphics2D
    private val component: DrawComponent
        init {
            frame.setSize(width, height)
            frame.addWindowListener(object : WindowListener {
                override fun windowOpened(e: WindowEvent) {}
                override fun windowClosing(e: WindowEvent) {
                    provider.reset()
                    if (Config.GUI)
                        GUI.thread.interrupt()
                }
                override fun windowClosed(e: WindowEvent) {}
                override fun windowIconified(e: WindowEvent) {}
                override fun windowDeiconified(e: WindowEvent) {}
                override fun windowActivated(e: WindowEvent) {}
                override fun windowDeactivated(e: WindowEvent) {}
            })
            frame.isResizable = false
            frame.isVisible = true
            image = BufferedImage(width, height, BufferedImage.TYPE_INT_RGB)
            (image.graphics as Graphics2D).setRenderingHint(RenderingHints.KEY_ANTIALIASING , RenderingHints.VALUE_ANTIALIAS_ON)
            graphics = image.createGraphics()
            image = graphics.deviceConfiguration.createCompatibleImage(width, height, Transparency.TRANSLUCENT)
            graphics.dispose()
            graphics = image.createGraphics()
            graphics.color = Color.BLACK
            component = DrawComponent(this, width, height)
            frame.add(component)
        }

    fun update() {
        frame.repaint()
    }

    class DrawComponent(private val draw: HimeDrawToken, width: Int, height: Int) : JComponent() {
        init {
            preferredSize = Dimension(width, height)
        }

        public override fun paintComponent(g: Graphics) {
            super.paintComponent(g)
            val g2 = g as Graphics2D
            g2.setRenderingHint(
                RenderingHints.KEY_INTERPOLATION,
                RenderingHints.VALUE_INTERPOLATION_BILINEAR
            )
            g2.drawImage(draw.image, null, null)
        }
    }
}