package cn.wumoe.hime.module.deaw

import cn.wumoe.hime.api.scripting.HimeContext
import cn.wumoe.hime.inter.Function
import cn.wumoe.hime.inter.Module
import cn.wumoe.hime.lexer.Num
import cn.wumoe.hime.lexer.Token
import cn.wumoe.hime.lexer.Word
import java.awt.Color
import java.awt.Graphics2D
import java.awt.RenderingHints
import java.awt.Transparency
import java.awt.image.BufferedImage

class DrawModule : Module("hime.draw") {
    override fun init(context: HimeContext) {
        addFunction(Draw())         // draw
        addFunction(Color())        // draw-color
        addFunction(Clear())        // draw-clear
        addFunction(DrawLine())     // draw-line
        addFunction(DrawRect())     // draw-rect
        addFunction(DrawRectRound())// draw-rect-round
        addFunction(FillRect())     // fill-rect
        addFunction(FillRectRound())// fill-rect-round
        addFunction(DrawArc())      // draw-arc
        addFunction(FillArc())      // fill-arc
        addFunction(DrawOval())     // draw-oval
        addFunction(FillOval())     // fill-oval
        addFunction(DrawWord())     // draw-word
        addFunction(DrawPolygon())  // draw-polygon
        addFunction(FillPolygon())  // fill-polygon
    }

    // (draw width height)
    class Draw : Function("draw") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.size >= 2 && pars[0] is Num && pars[1] is Num)
                HimeDrawToken((pars[0] as Num).value.intValueExact(), (pars[1] as Num).value.intValueExact())
            else
                Word.NIL
        }
    }

    // (draw-color draw r g b)
    class Color : Function("draw-color") {
        override fun call(pars: Array<out Token>): Token {
            if (pars.size >= 4 && pars[0] is HimeDrawToken
                && pars[1] is Num && pars[2] is Num && pars[3] is Num)
                (pars[0] as HimeDrawToken).graphics.color =
                    Color((pars[1] as Num).value.intValueExact(),
                    (pars[2] as Num).value.intValueExact(),
                    (pars[3] as Num).value.intValueExact())
            return Word.NIL
        }
    }

    // (draw-color draw)
    class Clear : Function("draw-clear") {
        override fun call(pars: Array<out Token>): Token {
            if (pars.isNotEmpty() && pars[0] is HimeDrawToken) {
                val draw = pars[0] as HimeDrawToken
                draw.image = BufferedImage(draw.frame.width, draw.frame.height, BufferedImage.TYPE_INT_RGB)
                (draw.image.graphics as Graphics2D).setRenderingHint(RenderingHints.KEY_ANTIALIASING , RenderingHints.VALUE_ANTIALIAS_ON)
                draw.graphics = draw.image.createGraphics()
                draw.image = draw.graphics.deviceConfiguration.createCompatibleImage(draw.frame.width, draw.frame.height, Transparency.TRANSLUCENT)
                draw.graphics.dispose()
                draw.graphics = draw.image.createGraphics()
                draw.graphics.color = java.awt.Color.BLACK
            }
            return Word.NIL
        }
    }

    // (draw-polygon draw [(x y)])
    class DrawPolygon : Function("draw-polygon") {
        override fun call(pars: Array<out Token>): Token {
            if (pars.size >= 2 && pars[0] is HimeDrawToken
                && pars[1] is cn.wumoe.hime.lexer.Array
            ) {
                val draw = pars[0] as HimeDrawToken
                val p1 = pars[1] as cn.wumoe.hime.lexer.Array
                val xa = arrayListOf<Int>()
                val ya = arrayListOf<Int>()
                for (p in p1.tokens) {
                    val array = p as cn.wumoe.hime.lexer.Array
                    xa.add((array[0] as Num).value.intValueExact())
                    ya.add((array[1] as Num).value.intValueExact())
                }

                val graphics = draw.graphics
                graphics.drawPolygon(xa.toIntArray(), ya.toIntArray(), xa.size.coerceAtMost(ya.size))
                draw.update()
            }
            return Word.NIL
        }
    }

    // (fill-polygon draw [(x y)])
    class FillPolygon : Function("fill-polygon") {
        override fun call(pars: Array<out Token>): Token {
            if (pars.size >= 2 && pars[0] is HimeDrawToken
                && pars[1] is cn.wumoe.hime.lexer.Array
            ) {
                val draw = pars[0] as HimeDrawToken
                val p1 = pars[1] as cn.wumoe.hime.lexer.Array
                val xa = arrayListOf<Int>()
                val ya = arrayListOf<Int>()
                for (p in p1.tokens) {
                    val array = p as cn.wumoe.hime.lexer.Array
                    xa.add((array[0] as Num).value.intValueExact())
                    ya.add((array[1] as Num).value.intValueExact())
                }

                val graphics = draw.graphics
                graphics.fillPolygon(xa.toIntArray(), ya.toIntArray(), xa.size.coerceAtMost(ya.size))
                draw.update()
            }
            return Word.NIL
        }
    }

    // (draw-line draw (x1 y1) (x2 y2))
    class DrawLine : Function("draw-line") {
        override fun call(pars: Array<out Token>): Token {
            if (pars.size >= 3 && pars[0] is HimeDrawToken
                && pars[1] is cn.wumoe.hime.lexer.Array
                && pars[2] is cn.wumoe.hime.lexer.Array) {
                val draw = pars[0] as HimeDrawToken
                val p1 = pars[1] as cn.wumoe.hime.lexer.Array
                val p2 = pars[2] as cn.wumoe.hime.lexer.Array
                if (p1[0] is Num && p1[1] is Num
                    && p2[0] is Num && p2[1] is Num) {
                    val x1 = (p1[0] as Num).value.intValueExact()
                    val y1 = (p1[1] as Num).value.intValueExact()
                    val x2 = (p2[0] as Num).value.intValueExact()
                    val y2 = (p2[1] as Num).value.intValueExact()
                    val graphics = draw.graphics
                    graphics.drawLine(x1, y1, x2, y2)
                    draw.update()
                }
            }
            return Word.NIL
        }
    }

    // (draw-word draw (x y) word)
    class DrawWord : Function("draw-word") {
        override fun call(pars: Array<out Token>): Token {
            if (pars.size >= 3 && pars[0] is HimeDrawToken
                && pars[1] is cn.wumoe.hime.lexer.Array) {
                val draw = pars[0] as HimeDrawToken
                val p1 = pars[1] as cn.wumoe.hime.lexer.Array
                if (p1[0] is Num && p1[1] is Num) {
                    val x = (p1[0] as Num).value.intValueExact()
                    val y = (p1[1] as Num).value.intValueExact()
                    val word = pars[2].toString()
                    val graphics = draw.graphics
                    graphics.drawString(word, x, y)
                    draw.update()
                }
            }
            return Word.NIL
        }
    }

    // (draw-rect draw (x y) (width height))
    class DrawRect : Function("draw-rect") {
        override fun call(pars: Array<out Token>): Token {
            if (pars.size >= 3 && pars[0] is HimeDrawToken
                && pars[1] is cn.wumoe.hime.lexer.Array
                && pars[2] is cn.wumoe.hime.lexer.Array) {
                val draw = pars[0] as HimeDrawToken
                val p1 = pars[1] as cn.wumoe.hime.lexer.Array
                val p2 = pars[2] as cn.wumoe.hime.lexer.Array
                if (p1[0] is Num && p1[1] is Num
                    && p2[0] is Num && p2[1] is Num) {
                    val x = (p1[0] as Num).value.intValueExact()
                    val y = (p1[1] as Num).value.intValueExact()
                    val width = (p2[0] as Num).value.intValueExact()
                    val height = (p2[1] as Num).value.intValueExact()
                    val graphics = draw.graphics
                    graphics.drawRect(x, y, width, height)
                    draw.update()
                }
            }
            return Word.NIL
        }
    }

    // (fill-rect draw (x y) (width height))
    class FillRect : Function("fill-rect") {
        override fun call(pars: Array<out Token>): Token {
            if (pars.size >= 3 && pars[0] is HimeDrawToken
                && pars[1] is cn.wumoe.hime.lexer.Array
                && pars[2] is cn.wumoe.hime.lexer.Array) {
                val draw = pars[0] as HimeDrawToken
                val p1 = pars[1] as cn.wumoe.hime.lexer.Array
                val p2 = pars[2] as cn.wumoe.hime.lexer.Array
                if (p1[0] is Num && p1[1] is Num
                    && p2[0] is Num && p2[1] is Num) {
                    val x = (p1[0] as Num).value.intValueExact()
                    val y = (p1[1] as Num).value.intValueExact()
                    val width = (p2[0] as Num).value.intValueExact()
                    val height = (p2[1] as Num).value.intValueExact()
                    val graphics = draw.graphics
                    graphics.fillRect(x, y, width, height)
                    draw.update()
                }
            }
            return Word.NIL
        }
    }


    // (draw-rect-round draw (x y) (width height) (arcWidth arcHeight))
    class DrawRectRound : Function("draw-rect-round") {
        override fun call(pars: Array<out Token>): Token {
            if (pars.size >= 4 && pars[0] is HimeDrawToken
                && pars[1] is cn.wumoe.hime.lexer.Array
                && pars[2] is cn.wumoe.hime.lexer.Array
                && pars[3] is cn.wumoe.hime.lexer.Array) {
                val draw = pars[0] as HimeDrawToken
                val p1 = pars[1] as cn.wumoe.hime.lexer.Array
                val p2 = pars[2] as cn.wumoe.hime.lexer.Array
                val p3 = pars[3] as cn.wumoe.hime.lexer.Array
                if (p1[0] is Num && p1[1] is Num
                    && p2[0] is Num && p2[1] is Num
                    && p3[0] is Num && p3[1] is Num) {
                    val x = (p1[0] as Num).value.intValueExact()
                    val y = (p1[1] as Num).value.intValueExact()
                    val width = (p2[0] as Num).value.intValueExact()
                    val height = (p2[1] as Num).value.intValueExact()
                    val arcWidth = (p3[0] as Num).value.intValueExact()
                    val arcHeight = (p3[1] as Num).value.intValueExact()
                    val graphics = draw.graphics
                    graphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight)
                    draw.update()
                }
            }
            return Word.NIL
        }
    }

    // (fill-rect draw (x y) (width height))
    class FillRectRound : Function("fill-rect-round") {
        override fun call(pars: Array<out Token>): Token {
            if (pars.size >= 4 && pars[0] is HimeDrawToken
                && pars[1] is cn.wumoe.hime.lexer.Array
                && pars[2] is cn.wumoe.hime.lexer.Array
                && pars[3] is cn.wumoe.hime.lexer.Array) {
                val draw = pars[0] as HimeDrawToken
                val p1 = pars[1] as cn.wumoe.hime.lexer.Array
                val p2 = pars[2] as cn.wumoe.hime.lexer.Array
                val p3 = pars[3] as cn.wumoe.hime.lexer.Array
                if (p1[0] is Num && p1[1] is Num
                    && p2[0] is Num && p2[1] is Num
                    && p3[0] is Num && p3[1] is Num) {
                    val x = (p1[0] as Num).value.intValueExact()
                    val y = (p1[1] as Num).value.intValueExact()
                    val width = (p2[0] as Num).value.intValueExact()
                    val height = (p2[1] as Num).value.intValueExact()
                    val arcWidth = (p3[0] as Num).value.intValueExact()
                    val arcHeight = (p3[1] as Num).value.intValueExact()
                    val graphics = draw.graphics
                    graphics.fillRoundRect(x, y, width, height, arcWidth, arcHeight)
                    draw.update()
                }
            }
            return Word.NIL
        }
    }

    // (draw-arc draw (x y) (width height) (startAngle arcAngle))
    class DrawArc : Function("draw-arc") {
        override fun call(pars: Array<out Token>): Token {
            if (pars.size >= 4 && pars[0] is HimeDrawToken
                && pars[1] is cn.wumoe.hime.lexer.Array
                && pars[2] is cn.wumoe.hime.lexer.Array
                && pars[3] is cn.wumoe.hime.lexer.Array) {
                val draw = pars[0] as HimeDrawToken
                val p1 = pars[1] as cn.wumoe.hime.lexer.Array
                val p2 = pars[2] as cn.wumoe.hime.lexer.Array
                val p3 = pars[3] as cn.wumoe.hime.lexer.Array
                if (p1[0] is Num && p1[1] is Num
                    && p2[0] is Num && p2[1] is Num
                    && p3[0] is Num && p3[1] is Num) {
                    val x = (p1[0] as Num).value.intValueExact()
                    val y = (p1[1] as Num).value.intValueExact()
                    val width = (p2[0] as Num).value.intValueExact()
                    val height = (p2[1] as Num).value.intValueExact()
                    val startAngle = (p3[0] as Num).value.intValueExact()
                    val arcAngle = (p3[1] as Num).value.intValueExact()
                    val graphics = draw.graphics
                    graphics.drawArc(x, y, width, height, startAngle, arcAngle)
                    draw.update()
                }
            }
            return Word.NIL
        }
    }

    // (fill-arc draw (x y) (width height) (startAngle arcAngle))
    class FillArc : Function("fill-arc") {
        override fun call(pars: Array<out Token>): Token {
            if (pars.size >= 4 && pars[0] is HimeDrawToken
                && pars[1] is cn.wumoe.hime.lexer.Array
                && pars[2] is cn.wumoe.hime.lexer.Array
                && pars[3] is cn.wumoe.hime.lexer.Array) {
                val draw = pars[0] as HimeDrawToken
                val p1 = pars[1] as cn.wumoe.hime.lexer.Array
                val p2 = pars[2] as cn.wumoe.hime.lexer.Array
                val p3 = pars[3] as cn.wumoe.hime.lexer.Array
                if (p1[0] is Num && p1[1] is Num
                    && p2[0] is Num && p2[1] is Num
                    && p3[0] is Num && p3[1] is Num) {
                    val x = (p1[0] as Num).value.intValueExact()
                    val y = (p1[1] as Num).value.intValueExact()
                    val width = (p2[0] as Num).value.intValueExact()
                    val height = (p2[1] as Num).value.intValueExact()
                    val startAngle = (p3[0] as Num).value.intValueExact()
                    val arcAngle = (p3[1] as Num).value.intValueExact()
                    val graphics = draw.graphics
                    graphics.fillArc(x, y, width, height, startAngle, arcAngle)
                    draw.update()
                }
            }
            return Word.NIL
        }
    }

    // (draw-oval draw (x y) (width height))
    class DrawOval : Function("draw-oval") {
        override fun call(pars: Array<out Token>): Token {
            if (pars.size >= 3 && pars[0] is HimeDrawToken
                && pars[1] is cn.wumoe.hime.lexer.Array
                && pars[2] is cn.wumoe.hime.lexer.Array) {
                val draw = pars[0] as HimeDrawToken
                val p1 = pars[1] as cn.wumoe.hime.lexer.Array
                val p2 = pars[2] as cn.wumoe.hime.lexer.Array
                if (p1[0] is Num && p1[1] is Num
                    && p2[0] is Num && p2[1] is Num) {
                    val x = (p1[0] as Num).value.intValueExact()
                    val y = (p1[1] as Num).value.intValueExact()
                    val width = (p2[0] as Num).value.intValueExact()
                    val height = (p2[1] as Num).value.intValueExact()
                    val graphics = draw.graphics
                    graphics.drawOval(x, y, width, height)
                    draw.update()
                }
            }
            return Word.NIL
        }
    }

    // (fill-oval draw (x y) (width height))
    class FillOval : Function("fill-oval") {
        override fun call(pars: Array<out Token>): Token {
            if (pars.size >= 3 && pars[0] is HimeDrawToken
                && pars[1] is cn.wumoe.hime.lexer.Array
                && pars[2] is cn.wumoe.hime.lexer.Array) {
                val draw = pars[0] as HimeDrawToken
                val p1 = pars[1] as cn.wumoe.hime.lexer.Array
                val p2 = pars[2] as cn.wumoe.hime.lexer.Array
                if (p1[0] is Num && p1[1] is Num
                    && p2[0] is Num && p2[1] is Num) {
                    val x = (p1[0] as Num).value.intValueExact()
                    val y = (p1[1] as Num).value.intValueExact()
                    val width = (p2[0] as Num).value.intValueExact()
                    val height = (p2[1] as Num).value.intValueExact()
                    val graphics = draw.graphics
                    graphics.fillOval(x, y, width, height)
                    draw.update()
                }
            }
            return Word.NIL
        }
    }

}