package cn.wumoe.hime.module

import cn.wumoe.hime.api.scripting.HimeContext
import cn.wumoe.hime.inter.Function
import cn.wumoe.hime.inter.Module
import cn.wumoe.hime.lexer.*

class TypeModule : Module("hime.type"){
    override fun init(context: HimeContext) {
        addFunction(IsString())     // is-string
        addFunction(IsNum())        // is-num
        addFunction(IsReal())       // is-real
        addFunction(IsArray())      // is-list
    }

    class IsString : Function("is-string") {
        override fun call(pars: Array<out Token>): Token {
            for (token in pars)
                if (token !is Word || token.tag != Tag.STR)
                    return Word.False
            return Word.True
        }
    }

    class IsNum : Function("is-num") {
        override fun call(pars: Array<out Token>): Token {
            for (token in pars)
                if (token !is Num)
                    return Word.False
            return Word.True
        }
    }

    class IsReal : Function("is-real") {
        override fun call(pars: Array<out Token>): Token {
            for (token in pars)
                if (token !is Real)
                    return Word.False
            return Word.True
        }
    }

    class IsArray : Function("is-list") {
        override fun call(pars: Array<out Token>): Token {
            for (token in pars)
                if (token !is cn.wumoe.hime.lexer.Array)
                    return Word.False
            return Word.True
        }
    }
}