package cn.wumoe.hime.module

import cn.wumoe.hime.api.scripting.HimeContext
import cn.wumoe.hime.inter.Module
import cn.wumoe.hime.inter.Function
import cn.wumoe.hime.lexer.Num
import cn.wumoe.hime.lexer.Token
import cn.wumoe.hime.lexer.Word
import kotlin.system.exitProcess

class SystemModule : Module("hime.system") {
    override fun init(context: HimeContext) {
        addFunction(Exit())     // exit
    }

    class Exit : Function("exit") {
        override fun call(pars: Array<out Token>): Token {
            if (pars.isNotEmpty() && pars[0] is Num)
                exitProcess((pars[0] as Num).value.toInt())
            return Word.NIL
        }
    }
}