package cn.wumoe.hime.module

import cn.wumoe.hime.api.scripting.HimeContext
import cn.wumoe.hime.inter.Function
import cn.wumoe.hime.inter.Module
import cn.wumoe.hime.lexer.Token
import cn.wumoe.hime.lexer.Word
import com.tulskiy.keymaster.common.Provider
import javax.swing.KeyStroke

class KeyModule : Module("hime.key") {
    companion object {
        val provider: Provider = Provider.getCurrentProvider(true)
    }

    override fun init(context: HimeContext) {
        addFunction(Monitor())      // monitor
    }

    class Monitor : Function("monitor") {
        override fun call(pars: Array<out Token>): Token {
            if (pars.size >= 2 && analysis.containsFunction(pars[1].toString())) {
                val func = analysis.getFunction(pars[1].toString())
                func.analysis = analysis
                provider.register(KeyStroke.getKeyStroke(pars[0].toString())) {
                    func.call(arrayOf())
                }
            }
            return Word.NIL
        }
    }
}